/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUi;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiException;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfileRegistry;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DrillDownEditor
extends JPanel {
    public static final String DRILL_DOWN_UI_PROFILE_PROPERTY = "drillDownUiProfile";
    private JPanel editorContainer = new JPanel();
    private DrillDownUi drillDownEditor;
    private final DrillDownModel model;
    private ReportDesignerContext designerContext;
    private DrillDownUiProfile selectedProfile;
    private boolean editFormulaFragment;
    private String[] fields = new String[0];

    public DrillDownEditor() {
        this.editorContainer.setLayout(new BorderLayout());
        JPanel cardHolder = new JPanel();
        cardHolder.setLayout(new CardLayout());
        cardHolder.add("2", this.editorContainer);
        cardHolder.add("1", Box.createRigidArea(new Dimension(450, 250)));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)cardHolder, "Center");
        this.model = new DrillDownModel();
        this.model.addPropertyChangeListener(new DrillDownFormulaUpdateListener());
    }

    public boolean isEditFormulaFragment() {
        return this.editFormulaFragment;
    }

    public void setEditFormulaFragment(boolean editFormulaFragment) {
        this.editFormulaFragment = editFormulaFragment;
    }

    public boolean isLimitedEditor() {
        return this.model.isLimitedEditor();
    }

    public void setLimitedEditor(boolean limitedEditor) {
        this.model.setLimitedEditor(limitedEditor);
    }

    public DrillDownUiProfile getDrillDownUiProfile() {
        return this.selectedProfile;
    }

    public void setDrillDownUiProfile(DrillDownUiProfile uiProfile) {
        DrillDownUiProfile oldProfile = this.selectedProfile;
        this.selectedProfile = uiProfile;
        if (this.selectedProfile == oldProfile) {
            return;
        }
        if (this.drillDownEditor != null) {
            this.drillDownEditor.deactivate();
        }
        this.editorContainer.removeAll();
        if (uiProfile == null) {
            this.drillDownEditor = null;
            this.editorContainer.revalidate();
            return;
        }
        try {
            this.drillDownEditor = uiProfile.createUI();
            this.drillDownEditor.init(this, this.designerContext, this.model, this.fields);
            this.editorContainer.add(this.drillDownEditor.getEditorPanel());
            this.editorContainer.revalidate();
        }
        catch (DrillDownUiException ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
            this.drillDownEditor = null;
            this.editorContainer.revalidate();
        }
        this.firePropertyChange(DRILL_DOWN_UI_PROFILE_PROPERTY, oldProfile, this.selectedProfile);
    }

    public String getDrillDownFormula() {
        return this.model.getResultDrillDownFormula(this.isEditFormulaFragment());
    }

    public String getTargetFormula() {
        return this.model.getTargetFormula();
    }

    public String getTooltipFormula() {
        return this.model.getTooltipFormula();
    }

    public ReportDesignerContext getDesignerContext() {
        return this.designerContext;
    }

    private void setDrillDownProfile(String drillDownProfileName) {
        DrillDownUiProfile[] profiles = DrillDownUiProfileRegistry.getInstance().getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            DrillDownUiProfile profile = profiles[i];
            if (!profile.canHandle(drillDownProfileName)) continue;
            DebugLog.log((Object)("Profile " + drillDownProfileName + " can be handled by " + profile));
            this.setDrillDownUiProfile(profile);
            return;
        }
        DebugLog.log((Object)("Profile " + drillDownProfileName + " can NOT be handled by anyone."));
        this.setDrillDownUiProfile(null);
    }

    public boolean initialize(ReportDesignerContext designerContext, String linkFormula, String tooltipFormula, String targetFormula, String[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.fields = (String[])fields.clone();
        this.model.setTargetFormula(targetFormula);
        this.model.setTooltipFormula(tooltipFormula);
        if (designerContext != null) {
            this.designerContext = designerContext;
            if (!this.model.initializeFromFormula(linkFormula, this.isEditFormulaFragment())) {
                this.setDefaultProfile();
                DebugLog.log((Object)"Failed to init from formula, selecting generic URL");
                return false;
            }
            this.setDrillDownProfile(this.model.getDrillDownConfig());
            DebugLog.log((Object)("Success on init from formula, selecting " + this.model.getDrillDownConfig()));
            return true;
        }
        DebugLog.log((Object)"There is no designer context, clearing selections");
        this.designerContext = null;
        this.model.clear();
        this.setDrillDownProfile(null);
        return false;
    }

    public void setDefaultProfile() {
        String defaultProfile = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.designer.core.editor.drilldown.default-profile");
        DrillDownUiProfile profile = DrillDownUiProfileRegistry.getInstance().getProfile(defaultProfile);
        this.setDrillDownUiProfile(profile);
    }

    private class DrillDownFormulaUpdateListener
    implements PropertyChangeListener {
        private String lastFormulaSeen;

        private DrillDownFormulaUpdateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String oldFormula = this.lastFormulaSeen;
            this.lastFormulaSeen = DrillDownEditor.this.model.getDrillDownFormula();
            if (!ObjectUtilities.equal((Object)oldFormula, (Object)this.lastFormulaSeen)) {
                DrillDownEditor.this.firePropertyChange("drillDownFormula", oldFormula, this.lastFormulaSeen);
            }
        }
    }
}

