/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.ComboBoxSelector;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownEditor;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.designer.core.util.ReportDesignerFunctionParameterEditor;

public class DrillDownFunctionParameterEditor
implements ReportDesignerFunctionParameterEditor {
    private DrillDownEditor editor;
    private EventListenerList eventListenerList;
    private ReportDesignerContext designerContext;
    private ComboBoxSelector drillDownSelector = new ComboBoxSelector(false);
    private JPanel panel;
    private boolean inParameterUpdate;
    private boolean inSetupUpdate;
    private FieldDefinition[] fieldDefinitions;

    public DrillDownFunctionParameterEditor() {
        this.drillDownSelector.addChangeListener(new DrillDownItemListener());
        this.editor = new DrillDownEditor();
        this.editor.setEditFormulaFragment(true);
        this.editor.setLimitedEditor(true);
        this.editor.addPropertyChangeListener("drillDownFormula", new DrillDownUpdateListener());
        this.editor.addPropertyChangeListener("drillDownUiProfile", new DrillDownProfileChangeHandler());
        this.eventListenerList = new EventListenerList();
        JPanel selectorPanel = new JPanel();
        selectorPanel.setLayout(new BorderLayout());
        selectorPanel.add((Component)new JLabel("Location:"), "North");
        selectorPanel.add((Component)this.drillDownSelector.getComponent(), "West");
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)selectorPanel, "North");
        this.panel.add((Component)this.editor, "Center");
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.designerContext;
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.designerContext = reportDesignerContext;
    }

    public void addParameterUpdateListener(ParameterUpdateListener parameterUpdateListener) {
        this.eventListenerList.add(ParameterUpdateListener.class, parameterUpdateListener);
    }

    public void removeParameterUpdateListener(ParameterUpdateListener parameterUpdateListener) {
        this.eventListenerList.remove(ParameterUpdateListener.class, parameterUpdateListener);
    }

    public Component getEditorComponent() {
        return this.panel;
    }

    public void setFields(FieldDefinition[] fieldDefinitions) {
        this.fieldDefinitions = (FieldDefinition[])fieldDefinitions.clone();
    }

    public void clearSelectedFunction() {
    }

    private String[] filterExtraFields() {
        if (this.fieldDefinitions == null) {
            return new String[0];
        }
        if (this.designerContext == null) {
            throw new IllegalStateException();
        }
        ReportDocumentContext activeContext = this.designerContext.getActiveContext();
        if (activeContext == null) {
            return new String[0];
        }
        HashSet<String> columnNames = new HashSet<String>(Arrays.asList(activeContext.getReportDataSchemaModel().getColumnNames()));
        ArrayList<String> retval = new ArrayList<String>();
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            FieldDefinition fieldDefinition = this.fieldDefinitions[i];
            if (columnNames.contains(fieldDefinition.getName())) continue;
            retval.add(fieldDefinition.getName());
        }
        return retval.toArray(new String[retval.size()]);
    }

    public void setSelectedFunction(FunctionParameterContext context) {
        if (this.inParameterUpdate) {
            return;
        }
        this.inSetupUpdate = true;
        try {
            if (this.editor.initialize(this.designerContext, context.getFunctionInformation().getFunctionText(), null, null, this.filterExtraFields()) && this.editor.getDrillDownUiProfile() == null) {
                this.editor.setDefaultProfile();
            }
        }
        finally {
            this.inSetupUpdate = false;
        }
    }

    private class DrillDownProfileChangeHandler
    implements PropertyChangeListener {
        private DrillDownProfileChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"drillDownUiProfile".equals(evt.getPropertyName())) {
                return;
            }
            DrillDownFunctionParameterEditor.this.drillDownSelector.setSelectedProfile(DrillDownFunctionParameterEditor.this.editor.getDrillDownUiProfile());
        }
    }

    private class DrillDownItemListener
    implements ChangeListener {
        private DrillDownItemListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DrillDownUiProfile uiProfile = DrillDownFunctionParameterEditor.this.drillDownSelector.getSelectedProfile();
            DrillDownFunctionParameterEditor.this.editor.setDrillDownUiProfile(uiProfile);
        }
    }

    private class DrillDownUpdateListener
    implements PropertyChangeListener {
        private DrillDownUpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (DrillDownFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            DrillDownFunctionParameterEditor.this.inParameterUpdate = true;
            try {
                ParameterUpdateListener[] parameterUpdateListeners = (ParameterUpdateListener[])DrillDownFunctionParameterEditor.this.eventListenerList.getListeners(ParameterUpdateListener.class);
                String formula = DrillDownFunctionParameterEditor.this.editor.getDrillDownFormula();
                if (formula == null) {
                    formula = "=DRILLDOWN(\"Text\"; \"Text\"; Any)";
                }
                for (int i = 0; i < parameterUpdateListeners.length; ++i) {
                    ParameterUpdateListener listener = parameterUpdateListeners[i];
                    listener.parameterUpdated(new ParameterUpdateEvent((Object)DrillDownFunctionParameterEditor.this, -1, formula, true));
                }
            }
            finally {
                DrillDownFunctionParameterEditor.this.inParameterUpdate = false;
            }
        }
    }
}

