/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.BasicLinkPanel;
import org.pentaho.reporting.designer.core.editor.drilldown.ComboBoxSelector;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownEditor;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownSelector;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class HyperlinkEditorPane
extends JPanel {
    private DrillDownSelector drillDownSelector = new ComboBoxSelector(true);
    private DrillDownEditor drillDownEditor;
    private JPanel cardHolder;
    private BasicLinkPanel basicLinkPanel;
    private CardLayout cardLayout;

    public HyperlinkEditorPane() {
        this.drillDownSelector.addChangeListener(new DrillDownItemListener());
        this.drillDownEditor = new DrillDownEditor();
        this.drillDownEditor.addPropertyChangeListener("drillDownUiProfile", new DrillDownProfileChangeHandler());
        this.basicLinkPanel = new BasicLinkPanel();
        this.cardLayout = new CardLayout();
        this.cardHolder = new JPanel();
        this.cardHolder.setLayout(this.cardLayout);
        this.cardHolder.add("2", this.drillDownEditor);
        this.cardHolder.add("1", this.basicLinkPanel);
        JPanel selectorPanel = new JPanel();
        selectorPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        selectorPanel.setLayout(new BorderLayout());
        selectorPanel.add((Component)new JLabel(Messages.getString("HyperlinkEditorPane.Location", new Object[0])), "North");
        selectorPanel.add((Component)this.drillDownSelector.getComponent(), "West");
        this.setLayout(new BorderLayout());
        this.add((Component)selectorPanel, "North");
        this.add((Component)this.cardHolder, "Center");
    }

    public void initializeFromStyle(ElementStyleSheet styleSheet, Map<StyleKey, Expression> styleExpressions, ReportDesignerContext designerContext) {
        this.basicLinkPanel.initializeFromStyle(styleSheet, styleExpressions, designerContext);
        String targetFormula = this.computeFormula(styleExpressions.get(ElementStyleKeys.HREF_WINDOW), (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW));
        String tooltipFormula = this.computeFormula(styleExpressions.get(ElementStyleKeys.HREF_TITLE), (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE));
        String formula = this.computeFormula(styleExpressions.get(ElementStyleKeys.HREF_TARGET));
        boolean initializedWithDrillDown = this.drillDownEditor.initialize(designerContext, formula, tooltipFormula, targetFormula, new String[0]);
        if (!this.basicLinkPanel.isEmpty() && !initializedWithDrillDown) {
            this.drillDownSelector.setSelectedProfile(null);
        }
    }

    private String computeFormula(Expression expression) {
        if (expression instanceof FormulaExpression) {
            FormulaExpression formulaExpression = (FormulaExpression)expression;
            return formulaExpression.getFormula();
        }
        if (expression == null) {
            return null;
        }
        return null;
    }

    private String computeFormula(Expression expression, String staticValue) {
        if (expression instanceof FormulaExpression) {
            FormulaExpression formulaExpression = (FormulaExpression)expression;
            return formulaExpression.getFormula();
        }
        if (expression == null && !StringUtils.isEmpty((String)staticValue)) {
            return '=' + FormulaUtil.quoteString((String)staticValue);
        }
        return null;
    }

    public void commitValues(ElementStyleSheet styleSheet, Map<StyleKey, Expression> styleExpressions) {
        this.basicLinkPanel.commitValues(styleSheet, styleExpressions);
        if (this.drillDownSelector.getSelectedProfile() == null) {
            return;
        }
        String formulaText = this.drillDownEditor.getDrillDownFormula();
        if (!StringUtils.isEmpty((String)formulaText)) {
            FormulaExpression formulaExpression = new FormulaExpression();
            formulaExpression.setFormula(formulaText);
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TARGET, null);
            styleExpressions.put(ElementStyleKeys.HREF_TARGET, (Expression)formulaExpression);
        } else {
            styleExpressions.put(ElementStyleKeys.HREF_TARGET, null);
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TARGET, null);
        }
        String targetText = this.drillDownEditor.getTargetFormula();
        if (!StringUtils.isEmpty((String)targetText)) {
            String staticText = FormulaUtil.extractStaticTextFromFormula((String)targetText);
            if (staticText != null) {
                styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, (Object)staticText);
                styleExpressions.put(ElementStyleKeys.HREF_WINDOW, null);
            } else {
                FormulaExpression formulaExpression = new FormulaExpression();
                formulaExpression.setFormula(targetText);
                styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, null);
                styleExpressions.put(ElementStyleKeys.HREF_WINDOW, (Expression)formulaExpression);
            }
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, null);
            styleExpressions.put(ElementStyleKeys.HREF_WINDOW, null);
        }
        String tooltipText = this.drillDownEditor.getTooltipFormula();
        if (!StringUtils.isEmpty((String)tooltipText)) {
            String staticText = FormulaUtil.extractStaticTextFromFormula((String)tooltipText);
            if (staticText != null) {
                styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, (Object)staticText);
                styleExpressions.put(ElementStyleKeys.HREF_TITLE, null);
            } else {
                FormulaExpression formulaExpression = new FormulaExpression();
                formulaExpression.setFormula(tooltipText);
                styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, null);
                styleExpressions.put(ElementStyleKeys.HREF_TITLE, (Expression)formulaExpression);
            }
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, null);
            styleExpressions.put(ElementStyleKeys.HREF_TITLE, null);
        }
    }

    private class DrillDownProfileChangeHandler
    implements PropertyChangeListener {
        private DrillDownProfileChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"drillDownUiProfile".equals(evt.getPropertyName())) {
                return;
            }
            HyperlinkEditorPane.this.drillDownSelector.setSelectedProfile(HyperlinkEditorPane.this.drillDownEditor.getDrillDownUiProfile());
        }
    }

    private class DrillDownItemListener
    implements ChangeListener {
        private DrillDownItemListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DrillDownUiProfile uiProfile = HyperlinkEditorPane.this.drillDownSelector.getSelectedProfile();
            HyperlinkEditorPane.this.drillDownEditor.setDrillDownUiProfile(uiProfile);
            if (uiProfile == null) {
                HyperlinkEditorPane.this.drillDownEditor.setEnabled(false);
                HyperlinkEditorPane.this.basicLinkPanel.setEnabled(true);
                HyperlinkEditorPane.this.cardLayout.last(HyperlinkEditorPane.this.cardHolder);
            } else {
                HyperlinkEditorPane.this.drillDownEditor.setEnabled(true);
                HyperlinkEditorPane.this.basicLinkPanel.setEnabled(false);
                HyperlinkEditorPane.this.cardLayout.first(HyperlinkEditorPane.this.cardHolder);
            }
        }
    }
}

