/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTableModel;
import org.pentaho.reporting.designer.core.editor.drilldown.FilteringParameterTableModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.FormulaFragmentCellRenderer;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class SystemParameterDialog
extends CommonDialog {
    private ElementMetaDataTable systemParameterTable;

    public SystemParameterDialog(DrillDownParameterTableModel parameterTableModel, ReportDesignerContext reportDesignerContext) {
        this.init(parameterTableModel, reportDesignerContext);
    }

    public SystemParameterDialog(Frame owner, DrillDownParameterTableModel parameterTableModel, ReportDesignerContext reportDesignerContext) throws HeadlessException {
        super(owner);
        this.init(parameterTableModel, reportDesignerContext);
    }

    public SystemParameterDialog(Dialog owner, DrillDownParameterTableModel parameterTableModel, ReportDesignerContext reportDesignerContext) throws HeadlessException {
        super(owner);
        this.init(parameterTableModel, reportDesignerContext);
    }

    protected void init(DrillDownParameterTableModel parameterTableModel, ReportDesignerContext reportDesignerContext) {
        if (parameterTableModel == null) {
            throw new NullPointerException();
        }
        this.setTitle(Messages.getString("SystemParameterDialog.Title", new Object[0]));
        this.systemParameterTable = new ElementMetaDataTable();
        this.systemParameterTable.setReportDesignerContext(reportDesignerContext);
        this.systemParameterTable.setFormulaFragment(true);
        this.systemParameterTable.setDefaultEditor(GroupedName.class, new GroupedNameCellEditor());
        this.systemParameterTable.setDefaultRenderer(String.class, new FormulaFragmentCellRenderer());
        this.systemParameterTable.setModel(new FilteringParameterTableModel(DrillDownParameter.Type.SYSTEM, parameterTableModel));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.SystemParameter";
    }

    protected boolean hasCancelButton() {
        return false;
    }

    protected Component createContentPane() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)new JLabel(Messages.getString("SystemParameterDialog.Available", new Object[0])), "North");
        panel.add((Component)new JScrollPane(this.systemParameterTable), "Center");
        return panel;
    }

    public void showAdvancedEditor() {
        this.performEdit();
    }
}

