/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DefaultXulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.dom.Document;

public class GenericUrlDrillDownController
extends DefaultXulDrillDownController {
    private PathChangeHandler pathHandler;

    @Override
    public void init(ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] fields) {
        super.init(reportDesignerContext, model, fields);
        this.pathHandler = new PathChangeHandler();
        this.getModel().addPropertyChangeListener("drillDownPath", this.pathHandler);
        this.configureDisableTableOnEmptyFile();
    }

    protected void configureDisableTableOnEmptyFile() {
        Document doc = this.getXulDomContainer().getDocumentRoot();
        XulComponent paramTableElement = doc.getElementById("parameter-table");
        if (!(paramTableElement instanceof XulDrillDownParameterTable)) {
            return;
        }
        this.getWrapper().getModel().addPropertyChangeListener("drillDownPath", new CheckEmptyPathHandler(paramTableElement));
    }

    @Override
    public void deactivate() {
        this.getModel().removePropertyChangeListener("drillDownPath", this.pathHandler);
    }

    private class CheckEmptyPathHandler
    implements PropertyChangeListener {
        private XulComponent paramTableElement;

        private CheckEmptyPathHandler(XulComponent paramTableElement) {
            this.paramTableElement = paramTableElement;
            this.propertyChange(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtils.isEmpty((String)GenericUrlDrillDownController.this.getWrapper().getDrillDownPath())) {
                this.paramTableElement.setDisabled(true);
            } else {
                this.paramTableElement.setDisabled(false);
            }
        }
    }

    private class PathChangeHandler
    implements PropertyChangeListener {
        private PathChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String path = GenericUrlDrillDownController.this.getModel().getDrillDownPath();
            if (StringUtils.isEmpty((String)path)) {
                return;
            }
            if (path.matches("\\w+\\://.*")) {
                GenericUrlDrillDownController.this.getModel().setDrillDownConfig("generic-url");
            } else {
                GenericUrlDrillDownController.this.getModel().setDrillDownConfig("local-url");
            }
        }
    }
}

