/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.dom4j.io.DOMReader;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUi;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiException;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DefaultXulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DrillDownSwingLoader;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swing.SwingXulRunner;
import org.pentaho.ui.xul.swing.tags.SwingDialog;
import org.pentaho.ui.xul.swing.tags.SwingWindow;

public class XulDrillDownUi
implements DrillDownUi {
    private XulDrillDownController controller;
    private Component editor;
    private DrillDownModel model;
    private String[] validConfigs;
    private String configurationTag;

    public XulDrillDownUi(String[] validConfigs, String configurationTag) {
        if (validConfigs == null || validConfigs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (configurationTag == null) {
            throw new NullPointerException();
        }
        this.configurationTag = configurationTag;
        this.validConfigs = (String[])validConfigs.clone();
        this.editor = new JLabel("Editor has not been configured");
    }

    @Override
    public void init(Component parent, ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] extraFields) throws DrillDownUiException {
        block10: {
            if (model == null) {
                throw new NullPointerException();
            }
            if (reportDesignerContext == null) {
                throw new NullPointerException();
            }
            if (extraFields == null) {
                throw new NullPointerException();
            }
            try {
                this.model = model;
                DrillDownSwingLoader loader = new DrillDownSwingLoader();
                loader.setOuterContext(parent);
                String modelProfileName = model.getDrillDownConfig();
                String profileName = this.filter(modelProfileName);
                model.setDrillDownConfig(profileName);
                Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
                String xulDocument = configuration.getConfigProperty("org.pentaho.reporting.designer.core.editor.drilldown.xul-document." + this.configurationTag, "res://org/pentaho/reporting/designer/core/editor/drilldown/basic/basic-drilldown.xul");
                ResourceManager resourceManager = new ResourceManager();
                Resource resource = resourceManager.createDirectly((Object)xulDocument, org.w3c.dom.Document.class);
                org.w3c.dom.Document document = (org.w3c.dom.Document)resource.getResource();
                DOMReader domReader = new DOMReader();
                XulDomContainer container = loader.loadXulFragment(domReader.read(document));
                String className = configuration.getConfigProperty("org.pentaho.reporting.designer.core.editor.drilldown.xul-controller." + this.configurationTag, DefaultXulDrillDownController.class.getName());
                this.controller = (XulDrillDownController)ObjectUtilities.loadAndInstantiate((String)className, XulDrillDownController.class, XulDrillDownController.class);
                if (this.controller != null) {
                    this.controller.setName("controller");
                    this.controller.setXulDomContainer(container);
                    this.controller.init(reportDesignerContext, model, extraFields);
                    container.addEventHandler((XulEventHandler)this.controller);
                }
                SwingXulRunner runner = new SwingXulRunner();
                runner.addContainer(container);
                runner.initialize();
                Document documentRoot = ((XulDomContainer)runner.getXulDomContainers().get(0)).getDocumentRoot();
                XulComponent rootElement = documentRoot.getElementById("root");
                if (rootElement != null) {
                    this.editor = (Component)rootElement.getManagedObject();
                    break block10;
                }
                XulComponent rootEle = documentRoot.getRootElement();
                if (rootEle instanceof SwingWindow) {
                    SwingWindow window = (SwingWindow)rootEle;
                    JFrame rootFrame = (JFrame)window.getRootObject();
                    this.editor = rootFrame.getContentPane();
                    break block10;
                }
                if (rootEle instanceof SwingDialog) {
                    SwingDialog dialog = (SwingDialog)rootEle;
                    JDialog rootFrame = dialog.getDialog();
                    this.editor = rootFrame.getContentPane();
                    break block10;
                }
                throw new DrillDownUiException("Root element not a Frame: " + rootEle);
            }
            catch (XulException xe) {
                throw new DrillDownUiException(xe);
            }
            catch (ResourceException e) {
                throw new DrillDownUiException(e);
            }
        }
    }

    private String extractPropertiesName(String xulDocument) {
        int startIndex = 0;
        if (xulDocument.startsWith("res:/")) {
            startIndex = 5;
        }
        String base = xulDocument.endsWith(".xul") ? xulDocument.substring(startIndex, xulDocument.length() - 4) : xulDocument.substring(startIndex);
        return base.replace('/', '.');
    }

    private String filter(String modelProfileName) {
        for (int i = 0; i < this.validConfigs.length; ++i) {
            String config = this.validConfigs[i];
            if (!config.equals(modelProfileName)) continue;
            return modelProfileName;
        }
        return this.validConfigs[0];
    }

    @Override
    public Component getEditorPanel() {
        return this.editor;
    }

    @Override
    public DrillDownModel getModel() {
        if (this.controller != null) {
            return this.controller.getModel();
        }
        return this.model;
    }

    @Override
    public void deactivate() {
        if (this.controller != null) {
            this.controller.deactivate();
        }
    }
}

