/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.lvalues.DataTable;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class DrillDownModel {
    public static final String DRILL_DOWN_CONFIG_PROPERTY = "drillDownConfig";
    public static final String DRILL_DOWN_PATH_PROPERTY = "drillDownPath";
    public static final String DRILL_DOWN_PARAMETER_PROPERTY = "drillDownParameter";
    public static final String TOOLTIP_FORMULA_PROPERTY = "tooltipFormula";
    public static final String TARGET_FORMULA_PROPERTY = "targetFormula";
    private static final DrillDownParameter[] EMPTY_PARAMS = new DrillDownParameter[0];
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String drillDownConfig;
    private String drillDownPath;
    private DrillDownParameter[] drillDownParameters = new DrillDownParameter[0];
    private String tooltipFormula;
    private String targetFormula;
    private boolean limitedEditor;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isLimitedEditor() {
        return this.limitedEditor;
    }

    public void setLimitedEditor(boolean limitedEditor) {
        boolean oldLimitedEditor = this.limitedEditor;
        this.limitedEditor = limitedEditor;
        this.firePropertyChange("limitedEditor", oldLimitedEditor, limitedEditor);
    }

    public void setDrillDownConfig(String drillDownConfig) {
        String oldValue = this.drillDownConfig;
        this.drillDownConfig = drillDownConfig;
        this.firePropertyChange(DRILL_DOWN_CONFIG_PROPERTY, oldValue, drillDownConfig);
    }

    public String getDrillDownConfig() {
        return this.drillDownConfig;
    }

    public String getDrillDownPath() {
        return this.drillDownPath;
    }

    public void setDrillDownPath(String drillDownPath) {
        String oldValue = this.drillDownPath;
        this.drillDownPath = drillDownPath;
        this.firePropertyChange(DRILL_DOWN_PATH_PROPERTY, oldValue, drillDownPath);
    }

    public DrillDownParameter[] getDrillDownParameter() {
        return this.drillDownParameters;
    }

    public void setDrillDownParameter(DrillDownParameter[] drillDownParameters) {
        DrillDownParameter[] oldValue = this.drillDownParameters;
        this.drillDownParameters = (DrillDownParameter[])drillDownParameters.clone();
        this.firePropertyChange(DRILL_DOWN_PARAMETER_PROPERTY, oldValue, drillDownParameters);
    }

    public String getTooltipFormula() {
        return this.tooltipFormula;
    }

    public void setTooltipFormula(String tooltipFormula) {
        String oldTooltip = this.tooltipFormula;
        this.tooltipFormula = tooltipFormula;
        this.firePropertyChange(TOOLTIP_FORMULA_PROPERTY, oldTooltip, tooltipFormula);
    }

    public String getTargetFormula() {
        return this.targetFormula;
    }

    public void setTargetFormula(String targetFormula) {
        String oldTarget = this.targetFormula;
        this.targetFormula = targetFormula;
        this.firePropertyChange(TARGET_FORMULA_PROPERTY, oldTarget, targetFormula);
    }

    public void refresh() {
        this.firePropertyChange(DRILL_DOWN_PATH_PROPERTY, null, this.drillDownPath);
        this.firePropertyChange(DRILL_DOWN_CONFIG_PROPERTY, null, this.drillDownConfig);
        this.firePropertyChange(DRILL_DOWN_PARAMETER_PROPERTY, null, this.drillDownParameters);
        this.firePropertyChange(TOOLTIP_FORMULA_PROPERTY, null, this.tooltipFormula);
        this.firePropertyChange(TARGET_FORMULA_PROPERTY, null, this.targetFormula);
    }

    public void clear() {
        this.setDrillDownConfig(null);
        this.setDrillDownPath(null);
        this.setDrillDownParameter(new DrillDownParameter[0]);
    }

    public boolean initializeFromFormula(String formulaWithPrefix, boolean formulaFragment) {
        this.clear();
        if (!StringUtils.isEmpty((String)formulaWithPrefix, (boolean)true)) {
            String formula = formulaFragment ? formulaWithPrefix : FormulaUtil.extractFormula((String)formulaWithPrefix);
            try {
                FormulaFunction function;
                FormulaParser parser = new FormulaParser();
                LValue value = parser.parse(formula);
                if (value instanceof FormulaFunction && "DRILLDOWN".equals((function = (FormulaFunction)value).getFunctionName())) {
                    this.updateModelFromFunction(function);
                    return true;
                }
                DebugLog.log((Object)("Fall through on formula " + formula));
            }
            catch (Exception e) {
                DebugLog.log((Object)("Failed with formula " + formulaWithPrefix), (Throwable)e);
            }
        } else {
            DebugLog.log((Object)("formula is empty " + formulaWithPrefix));
        }
        return false;
    }

    public String getResultDrillDownFormula(boolean formulaFragment) {
        String formula = this.getDrillDownFormula();
        if (formula == null) {
            return null;
        }
        if (formulaFragment) {
            return formula.substring(1);
        }
        return formula;
    }

    public String getDrillDownFormula() {
        if (StringUtils.isEmpty((String)this.getDrillDownConfig())) {
            return null;
        }
        DrillDownParameter[] downParameters = this.getDrillDownParameter();
        if (StringUtils.isEmpty((String)this.getDrillDownPath()) && downParameters.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("=DRILLDOWN(");
        builder.append(FormulaUtil.quoteString((String)this.getDrillDownConfig()));
        builder.append("; ");
        if (StringUtils.isEmpty((String)this.getDrillDownPath())) {
            builder.append("NA()");
        } else {
            builder.append(FormulaUtil.quoteString((String)this.getDrillDownPath()));
        }
        builder.append("; {");
        for (int i = 0; i < downParameters.length; ++i) {
            DrillDownParameter downParameter;
            String paramName;
            if (i > 0) {
                builder.append(" | ");
            }
            if (StringUtils.isEmpty((String)(paramName = (downParameter = downParameters[i]).getName()))) {
                builder.append("NA()");
            } else {
                builder.append(FormulaUtil.quoteString((String)paramName));
            }
            builder.append("; ");
            String formulaFragment = downParameter.getFormulaFragment();
            if (StringUtils.isEmpty((String)formulaFragment)) continue;
            builder.append(formulaFragment);
        }
        builder.append("})");
        return builder.toString();
    }

    private void updateModelFromFunction(FormulaFunction function) {
        DrillDownParameter[] parameters;
        String pathText;
        LValue[] lValues = function.getChildValues();
        if (lValues.length == 0) {
            return;
        }
        LValue configValue = lValues[0];
        String configText = this.extractStringValue(configValue);
        if (lValues.length > 1) {
            LValue pathValue = lValues[1];
            pathText = this.extractStringValue(pathValue);
        } else {
            pathText = null;
        }
        if (lValues.length == 3) {
            LValue dataValue = lValues[2];
            if (dataValue instanceof DataTable) {
                ArrayList<DrillDownParameter> values = new ArrayList<DrillDownParameter>();
                DataTable paramsStaticValue = (DataTable)dataValue;
                int colCount = paramsStaticValue.getColumnCount();
                int rowCount = paramsStaticValue.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    LValue parameterTextValue;
                    if (colCount == 0) continue;
                    LValue parameterNameValue = paramsStaticValue.getValueAt(row, 0);
                    String parameterName = this.extractStringValue(parameterNameValue);
                    String parameterText = colCount > 1 ? ((parameterTextValue = paramsStaticValue.getValueAt(row, 1)) != null ? parameterTextValue.toString() : null) : null;
                    if (parameterName == null) continue;
                    values.add(new DrillDownParameter(parameterName, parameterText));
                }
                parameters = values.toArray(new DrillDownParameter[values.size()]);
            } else {
                parameters = EMPTY_PARAMS;
            }
        } else {
            parameters = EMPTY_PARAMS;
        }
        this.setDrillDownConfig(configText);
        this.setDrillDownPath(pathText);
        this.setDrillDownParameter(parameters);
    }

    private String extractStringValue(LValue pathValue) {
        String pathText;
        if (pathValue instanceof StaticValue) {
            StaticValue pathStaticValue = (StaticValue)pathValue;
            pathText = String.valueOf(pathStaticValue.getValue());
        } else {
            pathText = null;
        }
        return pathText;
    }
}

