/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.parser;

import java.util.ArrayList;
import org.pentaho.reporting.designer.core.editor.drilldown.model.Parameter;
import org.pentaho.reporting.designer.core.editor.drilldown.parser.ParameterAttributeReadHandler;
import org.pentaho.reporting.designer.core.editor.drilldown.parser.ParameterValuesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParameterReadHandler
extends AbstractXmlReadHandler {
    private Parameter parameter;
    private ArrayList<ParameterAttributeReadHandler> attributeReadHandlers = new ArrayList();
    private ParameterValuesReadHandler valuesReadHandler;

    protected void startParsing(Attributes attrs) throws SAXException {
        String name = attrs.getValue(this.getUri(), "name");
        this.parameter = new Parameter(name);
        this.parameter.setMandatory("true".equals(attrs.getValue(this.getUri(), "is-mandatory")));
        this.parameter.setStrict("true".equals(attrs.getValue(this.getUri(), "is-strict")));
        this.parameter.setMultiSelect("true".equals(attrs.getValue(this.getUri(), "is-multi-select")));
        this.parameter.setType(attrs.getValue(this.getUri(), "type"));
        this.parameter.setTimezoneHint(attrs.getValue(this.getUri(), "timezone-hint"));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("attribute".equals(tagName)) {
            ParameterAttributeReadHandler readHandler = new ParameterAttributeReadHandler();
            this.attributeReadHandlers.add(readHandler);
            return readHandler;
        }
        if ("values".equals(tagName)) {
            if (this.valuesReadHandler == null) {
                this.valuesReadHandler = new ParameterValuesReadHandler(this.parameter.getType());
            }
            return this.valuesReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.attributeReadHandlers.size(); ++i) {
            ParameterAttributeReadHandler readHandler = this.attributeReadHandlers.get(i);
            this.parameter.setAttribute(readHandler.getNamespace(), readHandler.getName(), readHandler.getValue());
        }
        if (this.valuesReadHandler != null) {
            this.parameter.setSelections(this.valuesReadHandler.getSelections());
        }
    }

    public Object getObject() throws SAXException {
        return this.parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }
}

