/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.swing;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.FormulaEditorPanel;

public class TooltipAndTargetPanel
extends JPanel {
    private JLabel targetLabel;
    private JComboBox targetComboBox;
    private JLabel tooltipLabel;
    private FormulaEditorPanel tooltipPanel;

    public TooltipAndTargetPanel() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.targetLabel = this.createTargetLabel();
        this.targetComboBox = this.createTargetComboBox();
        this.tooltipLabel = this.createTooltipLabel();
        this.tooltipPanel = this.createTooltipPanel();
    }

    private JLabel createTargetLabel() {
        return new JLabel(Messages.getString("DrillDownDialog.TargetInput.Label", new Object[0]));
    }

    private JComboBox createTargetComboBox() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("");
        comboBox.addItem("=\"_TOP\"");
        comboBox.addItem("=\"_BLANK\"");
        comboBox.addItem("=\"_PARENT\"");
        comboBox.setEditable(true);
        return comboBox;
    }

    private JLabel createTooltipLabel() {
        return new JLabel(Messages.getString("DrillDownDialog.TooltipInput.Label", new Object[0]));
    }

    private FormulaEditorPanel createTooltipPanel() {
        return new FormulaEditorPanel();
    }

    public void layoutComponents() {
        boolean basicIndent = false;
        int verticalGap = 2;
        int horizontalGap = 4;
        this.setLayout(new GridLayout(1, 2));
        JPanel tgPanel = new JPanel();
        JPanel ttPanel = new JPanel();
        this.add(tgPanel);
        this.add(ttPanel);
        SpringLayout targetLayout = new SpringLayout();
        tgPanel.setLayout(targetLayout);
        tgPanel.add(this.targetLabel);
        targetLayout.putConstraint("North", (Component)this.targetLabel, 0, "North", (Component)tgPanel);
        targetLayout.putConstraint("East", (Component)this.targetLabel, -4, "East", (Component)tgPanel);
        targetLayout.putConstraint("West", (Component)this.targetLabel, 0, "West", (Component)tgPanel);
        tgPanel.add(this.targetComboBox);
        targetLayout.putConstraint("North", (Component)this.targetComboBox, 2, "South", (Component)this.targetLabel);
        targetLayout.putConstraint("East", (Component)this.targetComboBox, -4, "East", (Component)tgPanel);
        targetLayout.putConstraint("West", (Component)this.targetComboBox, 0, "West", (Component)tgPanel);
        targetLayout.putConstraint("South", (Component)tgPanel, 0, "South", (Component)this.targetComboBox);
        SpringLayout tooltipLayout = new SpringLayout();
        ttPanel.setLayout(tooltipLayout);
        ttPanel.add(this.tooltipLabel);
        tooltipLayout.putConstraint("North", (Component)this.tooltipLabel, 0, "North", (Component)ttPanel);
        tooltipLayout.putConstraint("East", (Component)this.tooltipLabel, 0, "East", (Component)ttPanel);
        tooltipLayout.putConstraint("West", (Component)this.tooltipLabel, 0, "West", (Component)ttPanel);
        ttPanel.add(this.tooltipPanel);
        tooltipLayout.putConstraint("North", (Component)this.tooltipPanel, 2, "South", (Component)this.tooltipLabel);
        tooltipLayout.putConstraint("East", (Component)this.tooltipPanel, 0, "East", (Component)ttPanel);
        tooltipLayout.putConstraint("West", (Component)this.tooltipPanel, 0, "West", (Component)ttPanel);
        tooltipLayout.putConstraint("South", (Component)ttPanel, 0, "South", (Component)this.tooltipPanel);
    }

    public JComboBox getTargetComboBox() {
        return this.targetComboBox;
    }

    public FormulaEditorPanel getTooltipPanel() {
        return this.tooltipPanel;
    }

    public void hideContent() {
        this.setLayout(new SpringLayout());
        this.removeAll();
    }
}

