/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import bsh.ParseException;
import bsh.Parser;
import java.awt.event.ActionEvent;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.AbstractAction;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ScriptingExpressionEditor;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.misc.beanshell.BSHExpression;

public class BeanShellScriptingExpressionEditor
extends ScriptingExpressionEditor {
    private BSHExpression bshExpression;

    public BeanShellScriptingExpressionEditor() {
        this.setSyntaxEditingStyle("text/java");
        this.addValidateButton(new ValidateAction());
    }

    @Override
    public void initialize(Expression expression, ReportDesignerContext context) {
        this.bshExpression = (BSHExpression)expression;
        this.setText(this.bshExpression.getExpression());
    }

    @Override
    public void stopEditing() {
        this.bshExpression.setExpression(this.getText());
    }

    private String mapLanguageToSyntaxHighlighting(String language) {
        if ("beanshell".equals(language)) {
            return "text/java";
        }
        if ("groovy".equals(language)) {
            return "text/groovy";
        }
        if ("javascript".equals(language)) {
            return "text/javascript";
        }
        if ("jython".equals(language)) {
            return "text/python";
        }
        if ("xslt".equals(language)) {
            return "text/xml";
        }
        return "text/plain";
    }

    private class ValidateAction
    extends AbstractAction {
        private ValidateAction() {
            this.putValue("Name", EditorExpressionsMessages.getString("BeanShellScriptingExpressionEditor.Validation"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Parser parser = new Parser((Reader)new StringReader(BeanShellScriptingExpressionEditor.this.getText()));
            parser.setRetainComments(true);
            BeanShellScriptingExpressionEditor.this.setStatus(" ");
            try {
                while (!parser.Line()) {
                }
                BeanShellScriptingExpressionEditor.this.setStatus(EditorExpressionsMessages.getString("BeanShellScriptingExpressionEditor.ValidationComplete"));
            }
            catch (ParseException e1) {
                BeanShellScriptingExpressionEditor.this.setStatus(e1.getMessage());
            }
        }
    }
}

