/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionTreeCellRenderer;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionsTreeModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class ExpressionChooserDialog
extends CommonDialog {
    private JTree expressionsTree;
    private AddAction addAction;
    private Expression expression;

    public ExpressionChooserDialog() throws HeadlessException {
        this.init();
    }

    public ExpressionChooserDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ExpressionChooserDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(EditorExpressionsMessages.getString("ExpressionChooserDialog.Title"));
        this.setModal(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(new ExpressionSelectionHandler());
        this.expressionsTree = new JTree(ExpressionsTreeModel.getTreeModel());
        this.expressionsTree.setRootVisible(false);
        this.expressionsTree.setSelectionModel(selectionModel);
        this.expressionsTree.addMouseListener(new DblClickHandler());
        this.expressionsTree.setCellRenderer(new ExpressionTreeCellRenderer());
        this.addAction = new AddAction();
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ExpressionChooser";
    }

    protected Component createContentPane() {
        return new JScrollPane(this.expressionsTree);
    }

    protected boolean validateInputs(boolean onConfirm) {
        TreePath selectionPath = this.expressionsTree.getSelectionPath();
        Object o = selectionPath.getLastPathComponent();
        return o instanceof ExpressionMetaData;
    }

    public Expression performSelect() {
        this.expression = null;
        if (!this.performEdit()) {
            return null;
        }
        if (this.expression == null) {
            this.addAction.actionPerformed(null);
        }
        return this.expression;
    }

    private class ExpressionSelectionHandler
    implements TreeSelectionListener {
        private ExpressionSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            if (path == null) {
                ExpressionChooserDialog.this.addAction.setEnabled(false);
                return;
            }
            Object o = path.getLastPathComponent();
            if (o instanceof ExpressionMetaData) {
                ExpressionChooserDialog.this.addAction.setEnabled(true);
            } else {
                ExpressionChooserDialog.this.addAction.setEnabled(false);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private AddAction() {
            this.putValue("Name", EditorExpressionsMessages.getString("ExpressionChooserDialog.Add"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = ExpressionChooserDialog.this.expressionsTree.getSelectionPath();
            Object o = selectionPath.getLastPathComponent();
            if (!(o instanceof ExpressionMetaData)) {
                return;
            }
            try {
                ExpressionMetaData metaData = (ExpressionMetaData)o;
                ExpressionChooserDialog.this.expression = (Expression)metaData.getExpressionType().newInstance();
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
            ExpressionChooserDialog.this.setConfirmed(true);
            ExpressionChooserDialog.this.dispose();
        }
    }

    private class DblClickHandler
    extends MouseAdapter {
        private DblClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (e.getClickCount() < 2) {
                return;
            }
            if (ExpressionChooserDialog.this.addAction.isEnabled()) {
                ExpressionChooserDialog.this.addAction.actionPerformed(null);
            }
        }
    }
}

