/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionPropertyChangeUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.PlainMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ExpressionPropertiesTableModel
extends AbstractTableModel
implements ElementMetaDataTableModel,
GroupingModel {
    private static final Log logger = LogFactory.getLog(ExpressionPropertiesTableModel.class);
    private static final Expression[] EMPTY_ELEMENTS = new Expression[0];
    private static final ExpressionPropertyMetaData[] EMPTY_METADATA = new ExpressionPropertyMetaData[0];
    private static final GroupingHeader[] EMPTY_GROUPINGS = new GroupingHeader[0];
    private static final BeanUtility[] EMPTY_EDITORS = new BeanUtility[0];
    private ExpressionPropertyMetaData[] metaData;
    private GroupingHeader[] groupings;
    private TableStyle tableStyle = TableStyle.GROUPED;
    private Expression[] elements = EMPTY_ELEMENTS;
    private BeanUtility[] editors;
    private ReportDocumentContext activeContext;
    private boolean filterInlineExpressionProperty;

    public ExpressionPropertiesTableModel() {
        this.metaData = EMPTY_METADATA;
        this.groupings = EMPTY_GROUPINGS;
        this.editors = EMPTY_EDITORS;
    }

    public boolean isFilterInlineExpressionProperty() {
        return this.filterInlineExpressionProperty;
    }

    public void setFilterInlineExpressionProperty(boolean filterInlineExpressionProperty) {
        this.filterInlineExpressionProperty = filterInlineExpressionProperty;
    }

    public ReportDocumentContext getActiveContext() {
        return this.activeContext;
    }

    public void setActiveContext(ReportDocumentContext activeContext) {
        this.activeContext = activeContext;
    }

    @Override
    public int getRowCount() {
        return this.metaData.length;
    }

    protected ExpressionPropertyMetaData getMetaData(int row) {
        return this.metaData[row];
    }

    protected GroupingHeader getGroupings(int row) {
        return this.groupings[row];
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        if (tableStyle == null) {
            throw new NullPointerException();
        }
        this.tableStyle = tableStyle;
        try {
            this.updateData(this.getData());
        }
        catch (IntrospectionException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            try {
                this.updateData(EMPTY_ELEMENTS);
            }
            catch (IntrospectionException e1) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    protected void updateData(Expression[] elements) throws IntrospectionException {
        this.elements = (Expression[])elements.clone();
        this.editors = new BeanUtility[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            this.editors[i] = new BeanUtility((Object)elements[i]);
        }
        ExpressionPropertyMetaData[] metaData = this.selectCommonAttributes();
        if (this.tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainMetaDataComparator());
            this.groupings = new GroupingHeader[metaData.length];
            this.metaData = metaData;
        } else if (this.tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainMetaDataComparator()));
            this.groupings = new GroupingHeader[metaData.length];
            this.metaData = metaData;
        } else {
            Arrays.sort(metaData, new GroupedMetaDataComparator());
            int groupCount = 0;
            Locale locale = Locale.getDefault();
            if (metaData.length > 0) {
                String oldValue = null;
                for (int i = 0; i < metaData.length; ++i) {
                    if (groupCount == 0) {
                        groupCount = 1;
                        ExpressionPropertyMetaData firstdata = metaData[i];
                        oldValue = firstdata.getGrouping(locale);
                        continue;
                    }
                    ExpressionPropertyMetaData data = metaData[i];
                    String grouping = data.getGrouping(locale);
                    if (ObjectUtilities.equal((Object)oldValue, (Object)grouping)) continue;
                    oldValue = grouping;
                    ++groupCount;
                }
            }
            ExpressionPropertyMetaData[] groupedMetaData = new ExpressionPropertyMetaData[metaData.length + groupCount];
            this.groupings = new GroupingHeader[groupedMetaData.length];
            int targetIdx = 0;
            GroupingHeader group = null;
            for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
                ExpressionPropertyMetaData data = metaData[sourceIdx];
                if (sourceIdx == 0) {
                    this.groupings[targetIdx] = group = new GroupingHeader(data.getGrouping(locale));
                    ++targetIdx;
                } else {
                    String newgroup = data.getGrouping(locale);
                    if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                        this.groupings[targetIdx] = group = new GroupingHeader(newgroup);
                        ++targetIdx;
                    }
                }
                this.groupings[targetIdx] = group;
                groupedMetaData[targetIdx] = data;
                ++targetIdx;
            }
            this.metaData = groupedMetaData;
        }
        this.fireTableDataChanged();
    }

    protected boolean isFiltered(ExpressionPropertyMetaData metaData) {
        if (metaData.isHidden()) {
            return true;
        }
        if (!WorkspaceSettings.getInstance().isVisible((MetaData)metaData)) {
            return true;
        }
        if (!this.isFilterInlineExpressionProperty()) {
            return false;
        }
        if ("name".equals(metaData.getName())) {
            return true;
        }
        return "dependencyLevel".equals(metaData.getName());
    }

    protected ExpressionPropertyMetaData[] selectCommonAttributes() {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        ArrayList<ExpressionPropertyMetaData> selectedArrays = new ArrayList<ExpressionPropertyMetaData>();
        for (int elementIdx = 0; elementIdx < this.elements.length; ++elementIdx) {
            Expression element = this.elements[elementIdx];
            String key = element.getClass().getName();
            if (!ExpressionRegistry.getInstance().isExpressionRegistered(key)) {
                return new ExpressionPropertyMetaData[0];
            }
            ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(key);
            ExpressionPropertyMetaData[] datas = metaData.getPropertyDescriptions();
            for (int styleIdx = 0; styleIdx < datas.length; ++styleIdx) {
                String name;
                Object attribute;
                ExpressionPropertyMetaData data = datas[styleIdx];
                if (this.isFiltered(data) || Boolean.TRUE.equals(attribute = attributes.get(name = data.getName())) || attribute != null) continue;
                if (elementIdx == 0) {
                    selectedArrays.add(data);
                    attributes.put(name, Boolean.TRUE);
                    continue;
                }
                attributes.put(name, Boolean.FALSE);
            }
        }
        return selectedArrays.toArray(new ExpressionPropertyMetaData[selectedArrays.size()]);
    }

    public void setData(Expression[] elements) {
        try {
            this.updateData(elements);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            try {
                this.updateData(EMPTY_ELEMENTS);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }

    public Expression[] getData() {
        return (Expression[])this.elements.clone();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return EditorExpressionsMessages.getString("ExpressionPropertiesTableModel.NameColumn");
            }
            case 1: {
                return EditorExpressionsMessages.getString("ExpressionPropertiesTableModel.ValueColumn");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName((MetaData)metaData);
            }
            case 1: {
                return this.computeFullValue(metaData);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.defineFullValue(metaData, aValue)) break;
                if (this.activeContext != null) {
                    AbstractReportDefinition abstractReportDefinition = this.activeContext.getReportDefinition();
                    for (int i = 0; i < this.elements.length; ++i) {
                        Expression expression = this.elements[i];
                        abstractReportDefinition.fireModelLayoutChanged((ReportElement)abstractReportDefinition, 0, (Object)expression);
                    }
                }
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    private boolean defineFullValue(ExpressionPropertyMetaData metaData, Object value) {
        boolean changed = false;
        try {
            for (int i = 0; i < this.editors.length; ++i) {
                BeanUtility element = this.editors[i];
                Object attribute = element.getProperty(metaData.getName());
                if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
                changed = true;
            }
            if (changed) {
                ReportDocumentContext activeContext1 = this.getActiveContext();
                ArrayList<ExpressionPropertyChangeUndoEntry> undos = new ArrayList<ExpressionPropertyChangeUndoEntry>();
                for (int i = 0; i < this.elements.length; ++i) {
                    BeanUtility element = this.editors[i];
                    String name = metaData.getName();
                    if (activeContext1 != null) {
                        Object oldValue = element.getProperty(name);
                        undos.add(new ExpressionPropertyChangeUndoEntry(this.elements[i], name, oldValue, value));
                    }
                    element.setProperty(name, value);
                }
                if (activeContext1 != null) {
                    UndoManager undo = activeContext1.getUndo();
                    undo.addChange(EditorExpressionsMessages.getString("ExpressionPropertiesTableModel.UndoName"), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
                }
            }
        }
        catch (BeanException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        return changed;
    }

    private Object computeFullValue(ExpressionPropertyMetaData metaData) {
        try {
            Object lastElement = null;
            if (this.elements.length > 0) {
                BeanUtility element = this.editors[0];
                lastElement = element.getProperty(metaData.getName());
            }
            return lastElement;
        }
        catch (BeanException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return null;
        }
    }

    public Class getClassForCell(int rowIndex, int columnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return metaData.getPropertyType();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public PropertyEditor getEditorForCell(int aRowIndex, int aColumnIndex) {
        ExpressionPropertyMetaData metaData = this.getMetaData(aRowIndex);
        if (metaData == null) {
            return null;
        }
        try {
            switch (aColumnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    PropertyEditor editor = metaData.getEditor();
                    if (editor != null) {
                        return editor;
                    }
                    Class<?> editorClass = metaData.getBeanDescriptor().getPropertyEditorClass();
                    if (editorClass != null) {
                        return (PropertyEditor)editorClass.newInstance();
                    }
                    if (String.class.equals((Object)metaData.getPropertyType())) {
                        return null;
                    }
                    return FastPropertyEditorManager.findEditor(metaData.getPropertyType());
                }
            }
            throw new IndexOutOfBoundsException();
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Failed to create property-editor", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getValueRole(int row, int column) {
        if (column != 1) {
            return null;
        }
        ExpressionPropertyMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getPropertyRole();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        if (column == 0) {
            return null;
        }
        ExpressionPropertyMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getExtraCalculationFields();
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        return this.getGroupings(index);
    }

    @Override
    public boolean isHeaderRow(int index) {
        return this.metaData[index] == null;
    }
}

