/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.HashNMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ExpressionsTreeModel
implements TreeModel {
    private static ExpressionsTreeModel model;
    private static Log logger;
    private ExpressionGroupingRoot root;
    private String[] groupings;
    private HashNMap<String, ExpressionMetaData> expressionsByGroup;

    public static ExpressionsTreeModel getTreeModel() {
        if (model != null) {
            return model;
        }
        if (ClassicEngineBoot.getInstance().isBootDone()) {
            model = new ExpressionsTreeModel();
            return model;
        }
        throw new IllegalStateException("ExpressionsTree: Requesting tree without booting is not a sane thing to do.");
    }

    private ExpressionsTreeModel() {
        ExpressionMetaData[] metaData = ExpressionRegistry.getInstance().getAllExpressionMetaDatas();
        Arrays.sort(metaData, new GroupedMetaDataComparator());
        Locale locale = Locale.getDefault();
        ArrayList<String> groupingsList = new ArrayList<String>(metaData.length);
        HashMap<String, String> diagnosticMap = new HashMap<String, String>();
        String group = null;
        for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
            ExpressionMetaData data = metaData[sourceIdx];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data) || StructureFunction.class.isAssignableFrom(data.getExpressionType())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Grouping : " + data.getGrouping(locale) + " - " + data.getGroupingOrdinal(locale) + " -> " + data.getExpressionType()));
            }
            String diagnosticGroup = group;
            if (sourceIdx == 0) {
                group = data.getGrouping(locale);
                groupingsList.add(group);
            } else {
                String newgroup = data.getGrouping(locale);
                if (!ObjectUtilities.equal((Object)newgroup, (Object)group)) {
                    if (!groupingsList.contains(newgroup)) {
                        group = newgroup;
                        groupingsList.add(newgroup);
                    } else {
                        logger.warn((Object)("Warning: Misconfigured Expression-metadata: Group already processed: '" + newgroup + "' - " + data.getExpressionType() + " - Previous: " + (String)diagnosticMap.get(diagnosticGroup)));
                    }
                }
            }
            diagnosticMap.put(group, data.getExpressionType().getName());
        }
        this.root = new ExpressionGroupingRoot();
        this.groupings = groupingsList.toArray(new String[groupingsList.size()]);
        this.expressionsByGroup = new HashNMap();
        for (int i = 0; i < metaData.length; ++i) {
            ExpressionMetaData exMetaData = metaData[i];
            if (StructureFunction.class.isAssignableFrom(exMetaData.getExpressionType()) || exMetaData.isHidden() || !WorkspaceSettings.getInstance().isShowExpertItems() && exMetaData.isExpert() || !WorkspaceSettings.getInstance().isShowDeprecatedItems() && exMetaData.isDeprecated()) continue;
            this.expressionsByGroup.add((Object)exMetaData.getGrouping(Locale.getDefault()), (Object)exMetaData);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.groupings[index];
        }
        if (parent instanceof String) {
            return this.expressionsByGroup.get((Object)((String)parent), index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.groupings.length;
        }
        if (parent instanceof String) {
            return this.expressionsByGroup.getValueCount((Object)((String)parent));
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof ExpressionMetaData;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        if (parent == this.root && child instanceof String) {
            int idx = Arrays.binarySearch(this.groupings, child);
            if (idx < 0 || idx >= this.groupings.length) {
                return -1;
            }
            return idx;
        }
        if (parent instanceof String) {
            Object[] metas = this.expressionsByGroup.toArray((Object)((String)parent));
            if (metas == null) {
                return -1;
            }
            for (int i = 0; i < metas.length; ++i) {
                if (child != metas[i]) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public static void main(String[] args) {
        ReportDesignerBoot.getInstance().start();
        ExpressionsTreeModel.getTreeModel();
    }

    static {
        logger = LogFactory.getLog(ExpressionsTreeModel.class);
    }

    private static class ExpressionGroupingRoot {
        private ExpressionGroupingRoot() {
        }

        public String toString() {
            return "<Root> You should not see this </root>";
        }
    }
}

