/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.fieldselector;

import java.awt.BorderLayout;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.fieldselector.FieldCellRenderer;
import org.pentaho.reporting.designer.core.editor.fieldselector.FieldSelectorTableModel;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFieldNode;
import org.pentaho.reporting.designer.core.model.DataSchemaUtility;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.designer.core.util.dnd.FieldDescriptionTransferable;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;

public class FieldSelectorPanel
extends SidePanel {
    private FieldSelectorTableModel dataModel;
    private JTable table;
    private ReportModelChangeHandler changeHandler;
    private AbstractReportDefinition report;

    public FieldSelectorPanel() {
        this.setLayout(new BorderLayout());
        this.dataModel = new FieldSelectorTableModel();
        this.table = new JTable();
        this.table.setModel(this.dataModel);
        this.table.setSelectionMode(0);
        this.table.setTransferHandler(new ColumnTransferHandler());
        this.table.setDefaultRenderer(ReportFieldNode.class, new FieldCellRenderer());
        this.table.setDragEnabled(true);
        this.changeHandler = new ReportModelChangeHandler();
        WorkspaceSettings.getInstance().addSettingsListener(this.changeHandler);
        this.add(new JScrollPane(this.table));
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        if (oldContext != null) {
            oldContext.removeReportDataChangeListener(this.changeHandler);
        }
        super.updateActiveContext(oldContext, newContext);
        if (newContext == null) {
            this.report = null;
            this.dataModel.setDataSchema(FieldSelectorTableModel.EMPTY_NODES);
        } else {
            this.report = newContext.getReportDefinition();
            newContext.addReportDataChangeListener(this.changeHandler);
            this.dataModel.setDataSchema(this.computeColumns(newContext));
        }
    }

    protected ReportFieldNode[] computeColumns(ReportDocumentContext context) {
        ContextAwareDataSchemaModel model = context.getReportDataSchemaModel();
        String[] columnNames = model.getColumnNames();
        ArrayList<ReportFieldNode> nodes = new ArrayList<ReportFieldNode>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            DataAttributes attributes = model.getDataSchema().getAttributes(name);
            if (attributes != null) {
                if (DataSchemaUtility.isFiltered(attributes, model.getDataAttributeContext())) continue;
                Class type = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, model.getDataAttributeContext());
                nodes.add(new ReportFieldNode(context, name, type));
                continue;
            }
            nodes.add(new ReportFieldNode(context, name, Object.class));
        }
        return nodes.toArray(new ReportFieldNode[nodes.size()]);
    }

    private class ColumnTransferHandler
    extends TransferHandler {
        private ColumnTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c != FieldSelectorPanel.this.table) {
                return null;
            }
            int selectedRow = FieldSelectorPanel.this.table.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            return new FieldDescriptionTransferable(FieldSelectorPanel.this.dataModel.getFieldName(selectedRow));
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class ReportModelChangeHandler
    implements ReportDataChangeListener,
    SettingsListener {
        private ReportModelChangeHandler() {
        }

        @Override
        public void dataModelChanged(ReportDocumentContext context) {
            ReportDesignerContext designerContext = FieldSelectorPanel.this.getReportDesignerContext();
            ReportDocumentContext activeContext = designerContext.getActiveContext();
            if (activeContext == null) {
                return;
            }
            FieldSelectorPanel.this.dataModel.setDataSchema(FieldSelectorPanel.this.computeColumns(activeContext));
        }

        @Override
        public void settingsChanged() {
            ReportDesignerContext designerContext = FieldSelectorPanel.this.getReportDesignerContext();
            ReportDocumentContext activeContext = designerContext.getActiveContext();
            if (activeContext == null) {
                return;
            }
            FieldSelectorPanel.this.dataModel.setDataSchema(FieldSelectorPanel.this.computeColumns(activeContext));
        }
    }
}

