/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.tools.configeditor.util.VerticalLayout;

public class AdvancedFontPropertiesPane
extends JPanel {
    private EncodingComboBoxModel encodingModel = EncodingComboBoxModel.createDefaultModel((Locale)Locale.getDefault(), (boolean)true);
    private JCheckBox embedFontsCheckbox = new JCheckBox(Messages.getString("AdvancedFontPropertiesPane.EmbedFonts", new Object[0]));
    private JCheckBox trimTextCheckbox = new JCheckBox(Messages.getString("AdvancedFontPropertiesPane.TrimText", new Object[0]));
    private JCheckBox overflowXCheckbox = new JCheckBox(Messages.getString("AdvancedFontPropertiesPane.OverflowX", new Object[0]));
    private JCheckBox overflowYCheckbox = new JCheckBox(Messages.getString("AdvancedFontPropertiesPane.OverflowY", new Object[0]));
    private JTextField quateField = new JTextField();

    public AdvancedFontPropertiesPane() {
        this.quateField.setColumns(30);
        this.setLayout((LayoutManager)new VerticalLayout());
        JPanel encodingCarrier = new JPanel();
        encodingCarrier.setLayout(new BoxLayout(encodingCarrier, 0));
        encodingCarrier.add(new JLabel(Messages.getString("AdvancedFontPropertiesPane.Encoding", new Object[0])));
        encodingCarrier.add(new JComboBox(this.encodingModel));
        JPanel pdfPanel = new JPanel();
        pdfPanel.setLayout((LayoutManager)new VerticalLayout());
        pdfPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("AdvancedFontPropertiesPane.PDFSettings", new Object[0])));
        pdfPanel.add(this.embedFontsCheckbox);
        pdfPanel.add(encodingCarrier);
        JPanel quateCarrier = new JPanel();
        quateCarrier.setLayout(new BoxLayout(quateCarrier, 0));
        quateCarrier.add(new JLabel(Messages.getString("AdvancedFontPropertiesPane.Quate", new Object[0])));
        quateCarrier.add(this.quateField);
        JPanel textProcessingPanel = new JPanel();
        textProcessingPanel.setLayout((LayoutManager)new VerticalLayout());
        textProcessingPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("AdvancedFontPropertiesPane.TextProcessingSettings", new Object[0])));
        textProcessingPanel.add(this.trimTextCheckbox);
        textProcessingPanel.add(this.overflowXCheckbox);
        textProcessingPanel.add(this.overflowYCheckbox);
        textProcessingPanel.add(quateCarrier);
        this.add(pdfPanel);
        this.add(textProcessingPanel);
    }

    public void initializeFromStyle(ElementStyleSheet style) {
        this.encodingModel.setSelectedEncoding((String)style.getStyleProperty(TextStyleKeys.FONTENCODING));
        this.embedFontsCheckbox.setSelected(style.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT));
        this.trimTextCheckbox.setSelected(style.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT));
        this.overflowXCheckbox.setSelected(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X));
        this.overflowYCheckbox.setSelected(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y));
        this.quateField.setText((String)style.getStyleProperty(TextStyleKeys.RESERVED_LITERAL));
    }

    public void commitValues(ElementStyleSheet styleSheet) {
        styleSheet.setStyleProperty(TextStyleKeys.FONTENCODING, (Object)this.encodingModel.getSelectedEncoding());
        styleSheet.setBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT, this.embedFontsCheckbox.isSelected());
        styleSheet.setBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT, this.trimTextCheckbox.isSelected());
        styleSheet.setBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X, this.overflowXCheckbox.isSelected());
        styleSheet.setBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y, this.overflowYCheckbox.isSelected());
        styleSheet.setStyleProperty(TextStyleKeys.RESERVED_LITERAL, (Object)this.quateField.getText());
    }
}

