/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.groups;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntry;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class GroupDataTableModel
extends AbstractTableModel
implements BulkDataProvider {
    private ArrayList<GroupDataEntry> data = new ArrayList();

    public void add(GroupDataEntry dataEntry) {
        if (this.data.add(dataEntry)) {
            this.fireTableDataChanged();
        }
    }

    public void remove(GroupDataEntry dataEntry) {
        if (this.data.remove(dataEntry)) {
            this.fireTableDataChanged();
        }
    }

    public void update(int index, GroupDataEntry dataEntry) {
        if (dataEntry == null) {
            throw new NullPointerException();
        }
        this.data.set(index, dataEntry);
        this.fireTableRowsUpdated(index, index);
    }

    public GroupDataEntry get(int index) {
        return this.data.get(index);
    }

    public GroupDataEntry[] toArray() {
        return this.data.toArray(new GroupDataEntry[this.data.size()]);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString("GroupDataTableModel.Name", new Object[0]);
        }
        return Messages.getString("GroupDataTableModel.Fields", new Object[0]);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return GroupDataEntry.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            GroupDataEntry dataEntry = this.get(rowIndex);
            GroupDataEntry newEntry = new GroupDataEntry(dataEntry.getInstanceID(), (String)aValue, dataEntry.getFields());
            this.update(rowIndex, newEntry);
            return;
        }
        this.update(rowIndex, (GroupDataEntry)aValue);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        GroupDataEntry dataEntry = this.get(rowIndex);
        if (columnIndex == 0) {
            return dataEntry.getName();
        }
        return dataEntry;
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public int getSize() {
        return this.data.size();
    }

    public int getBulkDataSize() {
        return this.data.size();
    }

    public Object[] getBulkData() {
        return this.data.toArray();
    }

    public void setBulkData(Object[] data) {
        this.data.clear();
        for (int i = 0; i < data.length; ++i) {
            GroupDataEntry o = (GroupDataEntry)data[i];
            this.data.add(o);
        }
        this.fireTableDataChanged();
    }
}

