/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.migration;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.IOException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.report.SaveReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.migration.Messages;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityConverter;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityConverterRegistry;
import org.pentaho.reporting.engine.classic.core.designtime.compat.CompatibilityUpdater;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterUtilities;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class MigrationDialog
extends CommonDialog {
    private ReportDocumentContext reportRenderContext;
    private JLabel warningLabel;
    private JEditorPane textArea;
    private int fromVersion;
    private int toVersion;

    public MigrationDialog() {
        this.init();
    }

    public MigrationDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public MigrationDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.warningLabel = new JLabel();
        this.textArea = new JEditorPane();
        this.textArea.setEditable(false);
        this.textArea.setBackground(new Color(0, 0, 0, 0));
        this.textArea.setOpaque(false);
        this.textArea.setEditorKit(new HTMLEditorKit());
        this.setTitle(Messages.getString("MigrationDialog.Title", new Object[0]));
        super.init();
    }

    protected void performInitialResize() {
        this.setSize(750, 550);
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.Migration";
    }

    protected Document createDescriptionText() throws IOException, BadLocationException {
        StringBuilder sb = new StringBuilder(10000);
        sb.append("<html><head></head><body>\n");
        CompatibilityConverterRegistry registry = CompatibilityConverterRegistry.getInstance();
        CompatibilityConverter[] converters = registry.getConverters();
        for (int i = 0; i < converters.length; ++i) {
            CompatibilityConverter converter = converters[i];
            if (this.toVersion <= 0 || converter.getTargetVersion() > this.toVersion) continue;
            sb.append(converter.getUpgradeDescription(Locale.getDefault()));
        }
        sb.append("</body></html>");
        return RichTextConverterUtilities.parseDocument((EditorKit)this.textArea.getEditorKit(), (Object)sb.toString());
    }

    protected Component createContentPane() {
        JPanel migrationPanel = new JPanel();
        migrationPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        migrationPanel.setLayout(new BorderLayout());
        migrationPanel.add((Component)this.warningLabel, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.textArea), "Center");
        panel.add((Component)migrationPanel, "South");
        return panel;
    }

    public void performMigration(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext) {
        this.reportRenderContext = reportRenderContext;
        this.toVersion = ClassicEngineBoot.computeCurrentVersionId();
        MasterReport masterReportElement = (MasterReport)this.reportRenderContext.getContextRoot();
        Integer compatibilityLevel = masterReportElement.getCompatibilityLevel();
        this.fromVersion = compatibilityLevel == null ? this.toVersion : compatibilityLevel;
        this.setupFromReportVersion();
        if (!super.performEdit()) {
            return;
        }
        if (!new SaveReportAction().saveReport(designerContext, reportRenderContext, (Component)((Object)this))) {
            return;
        }
        CompatibilityUpdater updater = new CompatibilityUpdater();
        updater.performUpdate((MasterReport)reportRenderContext.getContextRoot());
    }

    protected boolean validateInputs(boolean onConfirm) {
        if (!onConfirm) {
            return true;
        }
        return this.fromVersion != this.toVersion && JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getString("MigrationDialog.Confirm.Message", new Object[0]), Messages.getString("MigrationDialog.Confirm.Title", new Object[0]), 0) == 0;
    }

    private void setupFromReportVersion() {
        this.warningLabel.setText(Messages.getString("MigrationDialog.WarningLabel", ClassicEngineBoot.printVersion((int)this.fromVersion), ClassicEngineBoot.printVersion((int)this.toVersion)));
        try {
            this.textArea.setDocument(this.createDescriptionText());
        }
        catch (IOException e) {
            this.textArea.setText(Messages.getString("MigrationDialog.ErrorReadingDescription", new Object[0]));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

