/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.parameters.DataFactoryWrapper;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DataFactoryTreeModel
implements TreeModel {
    private ArrayList<DataFactoryWrapper> root;
    private EventListenerList listenerList = new EventListenerList();

    public DataFactoryTreeModel() {
        this.root = new ArrayList();
    }

    public void add(DataFactoryWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.root.add(wrapper);
        this.fireTreeDataChanged();
    }

    public void edit(int index, DataFactory newDataFactory) {
        if (newDataFactory == null) {
            throw new NullPointerException();
        }
        DataFactoryWrapper wrapper = this.root.get(index);
        wrapper.setEditedDataFactory(newDataFactory);
        this.fireTreeDataChanged(new TreePath(new Object[]{this.root, wrapper}));
    }

    public void importFromReport(CompoundDataFactory cdf) {
        int size = cdf.size();
        for (int i = 0; i < size; ++i) {
            this.root.add(new DataFactoryWrapper(cdf.getReference(i)));
        }
        this.fireTreeDataChanged();
    }

    public int size() {
        return this.root.size();
    }

    public DataFactoryWrapper get(int i) {
        return this.root.get(i);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            int size = 0;
            for (int i = 0; i < this.root.size(); ++i) {
                DataFactoryWrapper wrapper = this.root.get(i);
                if (wrapper.isRemoved()) continue;
                if (index == size) {
                    return wrapper;
                }
                ++size;
            }
            throw new IndexOutOfBoundsException();
        }
        if (parent instanceof DataFactoryWrapper) {
            DataFactoryWrapper df = (DataFactoryWrapper)parent;
            if (df.isRemoved()) {
                throw new IllegalStateException();
            }
            String[] queries = df.getEditedDataFactory().getQueryNames();
            return queries[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            int size = 0;
            for (int i = 0; i < this.root.size(); ++i) {
                DataFactoryWrapper wrapper = this.root.get(i);
                if (wrapper.isRemoved()) continue;
                ++size;
            }
            return size;
        }
        if (parent instanceof DataFactoryWrapper) {
            DataFactoryWrapper df = (DataFactoryWrapper)parent;
            if (df.isRemoved()) {
                throw new IllegalStateException();
            }
            String[] queries = df.getEditedDataFactory().getQueryNames();
            return queries.length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.root) {
            return false;
        }
        return !(node instanceof DataFactoryWrapper);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.fireTreeDataChanged(path);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            int size = 0;
            for (int i = 0; i < this.root.size(); ++i) {
                DataFactoryWrapper wrapper = this.root.get(i);
                if (wrapper.isRemoved()) continue;
                if (wrapper == child) {
                    return size;
                }
                ++size;
            }
            return -1;
        }
        if (parent instanceof DataFactoryWrapper) {
            DataFactoryWrapper df = (DataFactoryWrapper)parent;
            if (df.isRemoved()) {
                throw new IllegalStateException("Trues to access a node that has been removed.");
            }
            String[] queries = df.getEditedDataFactory().getQueryNames();
            for (int i = 0; i < queries.length; ++i) {
                String query = queries[i];
                if (!ObjectUtilities.equal((Object)query, (Object)child)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public void fireTreeDataChanged() {
        this.fireTreeDataChanged(new TreePath(this.getRoot()));
    }

    public void fireTreeDataChanged(TreePath treePath) {
        TreeModelListener[] treeModelListeners = this.getListeners();
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, treePath);
        for (int i = 0; i < treeModelListeners.length; ++i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeStructureChanged(treeEvent);
        }
    }

    protected TreeModelListener[] getListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void remove(DataFactory dataFactory) {
        for (int i = 0; i < this.root.size(); ++i) {
            DataFactoryWrapper wrapper = this.root.get(i);
            if (wrapper.getEditedDataFactory() != dataFactory) continue;
            wrapper.setEditedDataFactory(null);
            this.fireTreeDataChanged();
            return;
        }
    }

    public int indexOf(DataFactory dataFactory) {
        for (int i = 0; i < this.root.size(); ++i) {
            DataFactoryWrapper factoryWrapper = this.root.get(i);
            if (factoryWrapper.getEditedDataFactory() != dataFactory) continue;
            return i;
        }
        return -1;
    }

    public DataFactoryWrapper[] toArray() {
        return this.root.toArray(new DataFactoryWrapper[this.root.size()]);
    }
}

