/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.preview;

import javax.swing.Action;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.global.ShowPreviewPaneAction;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.util.Worker;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class DesignerPreviewPane
extends PreviewPane {
    private Action[] previewPaneActions;
    private ReportDesignerContext context;

    public DesignerPreviewPane(ReportDesignerContext context) {
        super(false);
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.setToolbarFloatable(false);
        this.initializeWithoutJob();
    }

    protected Worker createWorker() {
        Worker worker = super.createWorker();
        worker.setPriority(1);
        return worker;
    }

    protected Action[] getToolbarPreActions() {
        if (this.previewPaneActions == null) {
            ShowPreviewPaneAction action = new ShowPreviewPaneAction();
            action.setReportDesignerContext(this.context);
            this.previewPaneActions = new Action[]{action};
        }
        return (Action[])this.previewPaneActions.clone();
    }

    protected Configuration computeContextConfiguration() {
        return ClassicEngineBoot.getInstance().getGlobalConfig();
    }

    public void setStatusText(String statusText) {
        super.setStatusText(statusText);
        this.context.setStatusText(statusText);
    }

    public void setNumberOfPages(int numberOfPages) {
        super.setNumberOfPages(numberOfPages);
        this.context.setPageNumbers(this.getPageNumber(), this.getNumberOfPages());
    }

    public void setPageNumber(int pageNumber) {
        super.setPageNumber(pageNumber);
        this.context.setPageNumbers(this.getPageNumber(), this.getNumberOfPages());
    }
}

