/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ContextMenuUtility;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;
import org.pentaho.reporting.designer.core.editor.report.BandDndHandler;
import org.pentaho.reporting.designer.core.editor.report.GuidelineOverlayRenderer;
import org.pentaho.reporting.designer.core.editor.report.OverlappingElementOverlayRenderer;
import org.pentaho.reporting.designer.core.editor.report.OverlayRenderer;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditor;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorRegistry;
import org.pentaho.reporting.designer.core.editor.report.ReportElementInlineEditor;
import org.pentaho.reporting.designer.core.editor.report.SelectionOverlayInformation;
import org.pentaho.reporting.designer.core.editor.report.SelectionOverlayRenderer;
import org.pentaho.reporting.designer.core.editor.report.drag.CompoundDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.MouseDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.ResizeBottomDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.ResizeLeftDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.ResizeRightDragOperation;
import org.pentaho.reporting.designer.core.editor.report.drag.ResizeTopDragOperation;
import org.pentaho.reporting.designer.core.editor.report.layouting.AbstractElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.editor.report.snapping.FullSnapModel;
import org.pentaho.reporting.designer.core.editor.report.snapping.SnapToPositionModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.HorizontalPositionsModel;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.lineal.GuideLine;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelEvent;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelListener;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.BreakPositionsList;
import org.pentaho.reporting.designer.core.util.FpsCalculator;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.SubReportParameterChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;

public abstract class AbstractRenderComponent
extends JComponent
implements ReportElementEditorContext,
CellEditorListener {
    private static final long REPAINT_INTERVAL = 20L;
    private static final Log logger = LogFactory.getLog(AbstractRenderComponent.class);
    private static final BasicStroke SELECTION_STROKE = new BasicStroke(0.5f);
    private CellEditorRemover editorRemover;
    private RepaintHandler repaintHandler;
    private SettingsUpdateHandler settingsUpdateHandler;
    private ReportDesignerContext designerContext;
    private ReportDocumentContext renderContext;
    private boolean showLeftBorder;
    private boolean showTopBorder;
    private double gridSize;
    private int gridDivisions;
    private boolean terminateEditOnFocusLost;
    private Component editorComponent;
    private ReportElementInlineEditor inlineEditor;
    private MouseDragOperation operation;
    private MassElementStyleUndoEntryBuilder undoEntryBuilder;
    private FullSnapModel horizontalSnapModel;
    private FullSnapModel verticalSnapModel;
    private LinealModel verticalLinealModel;
    private LinealModel horizontalLinealModel;
    private HorizontalPositionsModel horizontalPositionsModel;
    private boolean focused;
    private SelectionOverlayInformation.InRangeIndicator currentIndicator;
    private SelectionStateHandler selectionStateHandler;
    private ArrayList<Object> oldValues = new ArrayList();
    private MouseSelectionHandler selectionHandler;
    private RequestFocusHandler focusHandler;
    private SelectionModelListener selectionModelListener;
    private RootBandChangeHandler changeHandler;
    private SimpleStyleResolver styleResolver;
    private ResolverStyleSheet resolvedStyle;
    private FpsCalculator fpsCalculator;
    private boolean paintingImmediately = false;

    protected AbstractRenderComponent(ReportDesignerContext designerContext, ReportDocumentContext renderContext) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        if (designerContext == null) {
            throw new NullPointerException();
        }
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setLayout(null);
        this.fpsCalculator = new FpsCalculator();
        this.showLeftBorder = true;
        this.showTopBorder = false;
        this.repaintHandler = new RepaintHandler(this);
        this.designerContext = designerContext;
        this.renderContext = renderContext;
        this.settingsUpdateHandler = new SettingsUpdateHandler();
        this.horizontalSnapModel = new FullSnapModel();
        this.verticalSnapModel = new FullSnapModel();
        this.terminateEditOnFocusLost = true;
        this.gridSize = WorkspaceSettings.getInstance().getGridSize();
        this.gridDivisions = WorkspaceSettings.getInstance().getGridDivisions();
        WorkspaceSettings.getInstance().addSettingsListener(this.settingsUpdateHandler);
        new DropTarget(this, new BandDndHandler(this));
        renderContext.getZoomModel().addZoomModelListener(this.repaintHandler);
        renderContext.getReportDefinition().addReportModelListener((ReportModelListener)new DragAbortReportModelListener());
        this.addMouseListener(new MouseEditorActionHandler());
        this.addKeyListener(new KeyboardElementMoveHandler());
        this.selectionStateHandler = new SelectionStateHandler();
        designerContext.addPropertyChangeListener("selectionWaiting", this.selectionStateHandler);
        this.focusHandler = new RequestFocusHandler();
        this.addMouseListener(this.focusHandler);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this.focusHandler);
        this.selectionHandler = new MouseSelectionHandler();
        this.addMouseListener(this.selectionHandler);
        this.addMouseMotionListener(this.selectionHandler);
        this.changeHandler = new RootBandChangeHandler();
        this.selectionModelListener = new SelectionModelListener();
        renderContext.getSelectionModel().addReportSelectionListener(this.selectionModelListener);
        new DropTarget(this, new BandDndHandler(this));
        this.installMouseOperationHandler();
        this.styleResolver = new SimpleStyleResolver(true);
        this.resolvedStyle = new ResolverStyleSheet();
        renderContext.getReportDefinition().addReportModelListener((ReportModelListener)this.changeHandler);
    }

    protected abstract ElementRenderer getElementRenderer();

    @Override
    public abstract Element getDefaultElement();

    public Band getRootBand() {
        return (Band)this.getElementRenderer().getElement();
    }

    public boolean isTerminateEditOnFocusLost() {
        return this.terminateEditOnFocusLost;
    }

    public void setTerminateEditOnFocusLost(boolean terminateEditOnFocusLost) {
        this.terminateEditOnFocusLost = terminateEditOnFocusLost;
    }

    protected abstract boolean isLocalElement(ReportElement var1);

    protected void installMouseOperationHandler() {
        MouseOperationHandler operationHandler = new MouseOperationHandler();
        this.addMouseListener(operationHandler);
        this.addMouseMotionListener(operationHandler);
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isShowLeftBorder() {
        return this.showLeftBorder;
    }

    public void setShowLeftBorder(boolean showLeftBorder) {
        this.showLeftBorder = showLeftBorder;
    }

    public boolean isShowTopBorder() {
        return this.showTopBorder;
    }

    public void setShowTopBorder(boolean showTopBorder) {
        this.showTopBorder = showTopBorder;
    }

    protected double getLeftBorder() {
        if (this.renderContext == null) {
            return 0.0;
        }
        if (!this.showLeftBorder) {
            return 0.0;
        }
        PageDefinition pageDefinition = ((MasterReport)this.renderContext.getContextRoot()).getPageDefinition();
        PageFormat pageFormat = pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getLeftBorder(pageFormat.getPaper());
    }

    protected double getTopBorder() {
        if (this.renderContext == null) {
            return 0.0;
        }
        if (!this.showTopBorder) {
            return 0.0;
        }
        PageDefinition pageDefinition = ((MasterReport)this.renderContext.getContextRoot()).getPageDefinition();
        PageFormat pageFormat = pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getTopBorder(pageFormat.getPaper());
    }

    @Override
    public Point2D normalize(Point2D e) {
        double topBorder = this.getTopBorder();
        double leftBorder = this.getLeftBorder();
        float scaleFactor = this.getRenderContext().getZoomModel().getZoomAsPercentage();
        double x = e.getX() / (double)scaleFactor - leftBorder;
        double y = e.getY() / (double)scaleFactor - topBorder;
        Point2D o = this.getOffset();
        o.setLocation(x, y + o.getY());
        return o;
    }

    protected Point2D getOffset() {
        StrictBounds bounds = this.getElementRenderer().getRootElementBounds();
        return new Point2D.Double(StrictGeomUtility.toExternalValue((long)bounds.getX()), StrictGeomUtility.toExternalValue((long)bounds.getY()));
    }

    @Override
    public ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    @Override
    public ReportDesignerContext getDesignerContext() {
        return this.designerContext;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fpsCalculator.isActive()) {
            this.fpsCalculator.tick();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(new Color(224, 224, 224));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int leftBorder = (int)this.getLeftBorder();
        int topBorder = (int)this.getTopBorder();
        float scaleFactor = this.getRenderContext().getZoomModel().getZoomAsPercentage();
        PageDefinition pageDefinition = ((MasterReport)this.getRenderContext().getContextRoot()).getPageDefinition();
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, pageDefinition.getWidth() * scaleFactor, this.getHeight());
        g2.translate((float)leftBorder * scaleFactor, (float)topBorder * scaleFactor);
        g2.clip(area);
        g2.setColor(Color.WHITE);
        g2.fill(area);
        Point2D offset = this.getOffset();
        if (offset.getX() != 0.0) {
            Rectangle2D.Double blackoutArea = new Rectangle2D.Double(0.0, 0.0, offset.getX() * (double)scaleFactor, this.getHeight());
            g2.setColor(Color.LIGHT_GRAY);
            g2.fill(blackoutArea);
        }
        this.paintGrid(g2);
        this.paintElementAlignment(g2);
        g2.dispose();
        Graphics2D logicalPageAreaG2 = (Graphics2D)g.create();
        logicalPageAreaG2.translate((float)leftBorder * scaleFactor, (float)topBorder * scaleFactor);
        logicalPageAreaG2.clip(area);
        logicalPageAreaG2.scale(scaleFactor, scaleFactor);
        try {
            ElementRenderer rendererRoot = this.getElementRenderer();
            if (rendererRoot != null && !rendererRoot.draw(logicalPageAreaG2)) {
                rendererRoot.handleError(this.designerContext, this.renderContext);
                logicalPageAreaG2.scale(1.0f / scaleFactor, 1.0f / scaleFactor);
                logicalPageAreaG2.setPaint(Color.WHITE);
                logicalPageAreaG2.fill(area);
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        logicalPageAreaG2.dispose();
        OverlayRenderer[] renderers = new OverlayRenderer[]{new OverlappingElementOverlayRenderer(this.getDefaultElement()), new SelectionOverlayRenderer(this.getDefaultElement()), new GuidelineOverlayRenderer(this.horizontalLinealModel, this.verticalLinealModel), new SelectionRectangleOverlayRenderer()};
        for (int i = 0; i < renderers.length; ++i) {
            OverlayRenderer renderer = renderers[i];
            Graphics2D selectionG2 = (Graphics2D)g.create();
            renderer.validate(this.getRenderContext(), scaleFactor, offset);
            renderer.draw(selectionG2, new Rectangle2D.Double(this.getLeftBorder(), this.getTopBorder(), this.getWidth(), this.getHeight()), this);
            selectionG2.dispose();
        }
    }

    protected void paintSelectionRectangle(Graphics2D g2) {
        Point origin = this.selectionHandler.getSelectionRectangleOrigin();
        Point target = this.selectionHandler.getSelectionRectangleTarget();
        if (origin == null || target == null) {
            return;
        }
        g2.setColor(Color.BLUE);
        g2.setStroke(SELECTION_STROKE);
        double y1 = Math.min(origin.getY(), target.getY());
        double x1 = Math.min(origin.getX(), target.getX());
        double y2 = Math.max(origin.getY(), target.getY());
        double x2 = Math.max(origin.getX(), target.getX());
        g2.draw(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
    }

    protected void paintGrid(Graphics2D g2d) {
        if (WorkspaceSettings.getInstance().isShowGrid()) {
            float scaleFactor = this.getRenderContext().getZoomModel().getZoomAsPercentage();
            double gridSize = this.getGridSize() * (double)scaleFactor;
            if (gridSize < 1.0) {
                return;
            }
            int gridDivisions = Math.max(1, this.getGridDivisions());
            Color primaryColor = WorkspaceSettings.getInstance().getGridColor();
            Color secondaryColor = ColorUtility.convertToBrighter((Color)primaryColor);
            g2d.setStroke(new BasicStroke(0.1f));
            int horizontalLineCount = 0;
            Line2D.Double line = new Line2D.Double();
            double gridHeight = this.getHeight();
            double gridWidth = this.getWidth();
            for (double w = gridSize; w < gridWidth; w += gridSize) {
                if (horizontalLineCount % gridDivisions == gridDivisions - 1) {
                    g2d.setColor(primaryColor);
                } else {
                    g2d.setColor(secondaryColor);
                }
                ++horizontalLineCount;
                line.setLine(w, 0.0, w, gridHeight);
                g2d.draw(line);
            }
            int verticalLineCount = 0;
            for (double h = gridSize; h < gridHeight; h += gridSize) {
                if (verticalLineCount % gridDivisions == gridDivisions - 1) {
                    g2d.setColor(primaryColor);
                } else {
                    g2d.setColor(secondaryColor);
                }
                ++verticalLineCount;
                line.setLine(0.0, h, gridWidth, h);
                g2d.draw(line);
            }
        }
    }

    protected void paintElementAlignment(Graphics2D g2d) {
        if (WorkspaceSettings.getInstance().isShowElementAlignmentHints()) {
            long[] hPositions;
            float scaleFactor = this.getRenderContext().getZoomModel().getZoomAsPercentage();
            g2d.setColor(WorkspaceSettings.getInstance().getAlignmentHintColor());
            g2d.setStroke(new BasicStroke(0.2f));
            double gridHeight = this.getHeight();
            double gridWidth = this.getWidth();
            if (this.getHorizontalPositionsModel() == null) {
                BreakPositionsList horizontalPositions = this.getHorizontalEdgePositions();
                hPositions = horizontalPositions.getKeys();
            } else {
                hPositions = this.getHorizontalPositionsModel().getBreaks();
            }
            Line2D.Double line = new Line2D.Double();
            for (int i = 0; i < hPositions.length; ++i) {
                double position = StrictGeomUtility.toExternalValue((long)hPositions[i]);
                double x = position * (double)scaleFactor;
                line.setLine(x, 0.0, x, gridHeight);
                g2d.draw(line);
            }
            Point2D offset = this.getOffset();
            BreakPositionsList verticalPositions = this.getVerticalEdgePositions();
            long[] vPositions = verticalPositions.getKeys();
            for (int i = 0; i < vPositions.length; ++i) {
                double position = StrictGeomUtility.toExternalValue((long)vPositions[i]) - offset.getY();
                double y2 = position * (double)scaleFactor;
                line.setLine(0.0, y2, gridWidth, y2);
                g2d.draw(line);
            }
        }
    }

    protected void updateGridSettings() {
        this.gridSize = WorkspaceSettings.getInstance().getGridSize();
        this.gridDivisions = WorkspaceSettings.getInstance().getGridDivisions();
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridDivisions() {
        return this.gridDivisions;
    }

    @Override
    public Element getElementForLocation(Point2D point, boolean onlySelected) {
        ElementRenderer rendererRoot = this.getElementRenderer();
        Element[] allNodes = rendererRoot.getElementsAt(point.getX(), point.getY());
        for (int i = allNodes.length - 1; i >= 0; --i) {
            Element element = allNodes[i];
            if (ModelUtility.isHideInLayoutGui((ReportElement)element)) continue;
            this.styleResolver.resolve((ReportElement)element, this.resolvedStyle);
            if (!this.resolvedStyle.getBooleanStyleProperty(ElementStyleKeys.VISIBLE) || onlySelected && !this.getRenderContext().getSelectionModel().isSelected(element)) continue;
            return element;
        }
        return null;
    }

    protected RootLevelBand findRootBandForPosition(Point2D point) {
        if (this.getElementRenderer() == null) {
            return null;
        }
        Element[] elementsAt = this.getElementRenderer().getElementsAt(point.getX(), point.getY());
        for (int i = elementsAt.length - 1; i >= 0; --i) {
            Element element = elementsAt[i];
            if (!(element instanceof RootLevelBand)) continue;
            return (RootLevelBand)element;
        }
        Section section = this.getElementRenderer().getElement();
        if (section instanceof RootLevelBand) {
            return (RootLevelBand)section;
        }
        return null;
    }

    public void dispose() {
        WorkspaceSettings.getInstance().removeSettingsListener(this.settingsUpdateHandler);
        if (this.verticalLinealModel != null) {
            this.verticalLinealModel.removeLinealModelListener(this.repaintHandler);
        }
        if (this.horizontalLinealModel != null) {
            this.horizontalLinealModel.removeLinealModelListener(this.repaintHandler);
        }
        if (this.getElementRenderer() != null) {
            this.getElementRenderer().removeChangeListener(this.repaintHandler);
        }
        this.designerContext.removePropertyChangeListener("selectionWaiting", this.selectionStateHandler);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.focusHandler);
        ReportDocumentContext renderContext = this.getRenderContext();
        renderContext.getReportDefinition().removeReportModelListener((ReportModelListener)this.changeHandler);
        renderContext.getSelectionModel().removeReportSelectionListener(this.selectionModelListener);
        this.getElementRenderer().dispose();
    }

    protected void removeEditor() {
        if (this.editorRemover != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
            this.editorRemover = null;
        }
        if (this.editorComponent == null) {
            this.inlineEditor = null;
            return;
        }
        this.remove(this.editorComponent);
        this.inlineEditor.removeCellEditorListener(this);
        this.editorComponent = null;
        this.inlineEditor = null;
    }

    protected ReportElementInlineEditor getCellEditor() {
        return this.inlineEditor;
    }

    protected boolean installEditor(ReportElementInlineEditor inlineEditor, Element element) {
        if (inlineEditor == null) {
            throw new NullPointerException();
        }
        this.inlineEditor = inlineEditor;
        CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
        if (data == null) {
            this.removeEditor();
            return false;
        }
        Component editorComponent = inlineEditor.getElementCellEditorComponent(this, (ReportElement)element);
        if (editorComponent == null) {
            this.removeEditor();
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        this.editorComponent = editorComponent;
        float zoomFactor = this.getRenderContext().getZoomModel().getZoomAsPercentage();
        Rectangle2D bounds = this.getElementRenderer().getBounds();
        int x = (int)((this.getLeftBorder() + StrictGeomUtility.toExternalValue((long)data.getX())) * (double)zoomFactor);
        int y = (int)(this.getTopBorder() + (StrictGeomUtility.toExternalValue((long)data.getY()) - bounds.getY()) * (double)zoomFactor);
        int width = (int)(StrictGeomUtility.toExternalValue((long)data.getWidth()) * (double)zoomFactor);
        int height = (int)(StrictGeomUtility.toExternalValue((long)data.getHeight()) * (double)zoomFactor);
        editorComponent.setBounds(x, y, width, height);
        this.add(editorComponent);
        editorComponent.validate();
        inlineEditor.addCellEditorListener(this);
        List<Element> selectedElements = this.getRenderContext().getSelectionModel().getSelectedElementsOfType(Element.class);
        Element[] visualElements = selectedElements.toArray(new Element[selectedElements.size()]);
        if (visualElements.length > 0) {
            this.oldValues = new ArrayList();
            for (int i = 0; i < visualElements.length; ++i) {
                Object attribute = visualElements[i].getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
                this.oldValues.add(attribute);
            }
        }
        return true;
    }

    protected boolean isEditing() {
        return this.inlineEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        List<Element> selectedElements = this.getRenderContext().getSelectionModel().getSelectedElementsOfType(Element.class);
        Element[] visualElements = selectedElements.toArray(new Element[selectedElements.size()]);
        if (visualElements.length > 0) {
            ArrayList<AttributeEditUndoEntry> undos = new ArrayList<AttributeEditUndoEntry>();
            for (int i = 0; i < visualElements.length; ++i) {
                Object attribute = visualElements[i].getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
                undos.add(new AttributeEditUndoEntry(visualElements[i].getObjectID(), "http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.oldValues.get(i), attribute));
            }
            this.getRenderContext().getUndo().addChange(Messages.getString("AbstractRenderComponent.InlineEditUndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
        this.removeEditor();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.operation = null;
        this.undoEntryBuilder = null;
        this.removeEditor();
    }

    @Override
    public JComponent getRepresentationContainer() {
        return this;
    }

    public LinealModel getVerticalLinealModel() {
        return this.verticalLinealModel;
    }

    public LinealModel getHorizontalLinealModel() {
        return this.horizontalLinealModel;
    }

    public HorizontalPositionsModel getHorizontalPositionsModel() {
        return this.horizontalPositionsModel;
    }

    protected void updateElements(Point2D normalizedPoint, boolean snapToGrid, boolean snapToElements) {
        if (this.operation != null) {
            this.horizontalSnapModel.setEnableElements(snapToElements || WorkspaceSettings.getInstance().isSnapToElements());
            this.horizontalSnapModel.setEnableGrid(snapToGrid || WorkspaceSettings.getInstance().isSnapToGrid());
            this.horizontalSnapModel.setEnableGuides(true);
            this.verticalSnapModel.setEnableElements(snapToElements || WorkspaceSettings.getInstance().isSnapToElements());
            this.verticalSnapModel.setEnableGrid(snapToGrid || WorkspaceSettings.getInstance().isSnapToGrid());
            this.verticalSnapModel.setEnableGuides(true);
            this.operation.update(normalizedPoint, this.getRenderContext().getZoomModel().getZoomAsPercentage());
        }
    }

    protected BreakPositionsList getHorizontalEdgePositions() {
        return this.getElementRenderer().getHorizontalEdgePositions();
    }

    protected BreakPositionsList getVerticalEdgePositions() {
        return this.getElementRenderer().getVerticalEdgePositions();
    }

    protected Element[] filterLocalElements(Element[] originalElements) {
        ArrayList<Element> result = new ArrayList<Element>(originalElements.length);
        for (int i = 0; i < originalElements.length; ++i) {
            Element element = originalElements[i];
            if (!this.isLocalElement((ReportElement)element)) continue;
            result.add(element);
        }
        return result.toArray(new Element[result.size()]);
    }

    protected void initializeDragOperation(Point2D originPoint, SelectionOverlayInformation.InRangeIndicator currentIndicator) {
        this.fpsCalculator.reset();
        this.fpsCalculator.setActive(true);
        List<Element> visualElements = this.getRenderContext().getSelectionModel().getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            return;
        }
        this.horizontalSnapModel.getGridModel().setGridSize(StrictGeomUtility.toInternalValue((double)this.getGridSize()));
        this.verticalSnapModel.getGridModel().setGridSize(StrictGeomUtility.toInternalValue((double)this.getGridSize()));
        this.horizontalSnapModel.setEnableGrid(WorkspaceSettings.getInstance().isSnapToGrid());
        this.verticalSnapModel.setEnableGrid(WorkspaceSettings.getInstance().isSnapToGrid());
        SnapToPositionModel horizontalGuildesPositions = this.horizontalSnapModel.getGuidesModel();
        horizontalGuildesPositions.clear();
        GuideLine[] hlines = this.horizontalLinealModel.getGuideLines();
        for (int i = 0; i < hlines.length; ++i) {
            GuideLine guideLine = hlines[i];
            if (!guideLine.isActive()) continue;
            horizontalGuildesPositions.add(StrictGeomUtility.toInternalValue((double)guideLine.getPosition()), null);
        }
        SnapToPositionModel verticalGuidesPositions = this.verticalSnapModel.getGuidesModel();
        verticalGuidesPositions.clear();
        GuideLine[] vlines = this.verticalLinealModel.getGuideLines();
        for (int i = 0; i < vlines.length; ++i) {
            GuideLine guideLine = vlines[i];
            if (!guideLine.isActive()) continue;
            verticalGuidesPositions.add(StrictGeomUtility.toInternalValue((double)guideLine.getPosition()), null);
        }
        SnapToPositionModel hElementModel = this.horizontalSnapModel.getElementModel();
        hElementModel.clear();
        BreakPositionsList horizontalPositions = this.getHorizontalEdgePositions();
        long[] horizontalKeys = this.horizontalPositionsModel == null ? horizontalPositions.getKeys() : this.horizontalPositionsModel.getBreaks();
        for (int i = 0; i < horizontalKeys.length; ++i) {
            long key = horizontalKeys[i];
            hElementModel.add(key, horizontalPositions.getOwner(key));
        }
        SnapToPositionModel vElementModel = this.verticalSnapModel.getElementModel();
        vElementModel.clear();
        BreakPositionsList verticalPositions = this.getVerticalEdgePositions();
        long[] verticalKeys = verticalPositions.getKeys();
        for (int i = 0; i < verticalKeys.length; ++i) {
            long key = verticalKeys[i];
            vElementModel.add(key, verticalPositions.getOwner(key));
        }
        switch (currentIndicator) {
            case MOVE: {
                this.operation = new MoveDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel);
                break;
            }
            case BOTTOM_CENTER: {
                this.operation = new ResizeBottomDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel);
                break;
            }
            case MIDDLE_RIGHT: {
                this.operation = new ResizeRightDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel);
                break;
            }
            case MIDDLE_LEFT: {
                this.operation = new ResizeLeftDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel);
                break;
            }
            case TOP_CENTER: {
                this.operation = new ResizeTopDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel);
                break;
            }
            case BOTTOM_LEFT: {
                CompoundDragOperation op = new CompoundDragOperation();
                op.add(new ResizeLeftDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                op.add(new ResizeBottomDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                this.operation = op;
                break;
            }
            case BOTTOM_RIGHT: {
                CompoundDragOperation op = new CompoundDragOperation();
                op.add(new ResizeRightDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                op.add(new ResizeBottomDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                this.operation = op;
                break;
            }
            case TOP_LEFT: {
                CompoundDragOperation op = new CompoundDragOperation();
                op.add(new ResizeLeftDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                op.add(new ResizeTopDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                this.operation = op;
                break;
            }
            case TOP_RIGHT: {
                CompoundDragOperation op = new CompoundDragOperation();
                op.add(new ResizeRightDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                op.add(new ResizeTopDragOperation(visualElements, originPoint, this.horizontalSnapModel, this.verticalSnapModel));
                this.operation = op;
                break;
            }
        }
        if (this.operation != null) {
            this.undoEntryBuilder = new MassElementStyleUndoEntryBuilder(visualElements);
        }
    }

    protected void finishDragOperation() {
        if (this.operation != null) {
            this.operation.finish();
            MassElementStyleUndoEntry undoEntry = this.undoEntryBuilder.finish();
            this.getRenderContext().getUndo().addChange(Messages.getString("AbstractRenderComponent.ResizeUndoName", new Object[0]), undoEntry);
        }
        this.operation = null;
        this.undoEntryBuilder = null;
        this.repaintConditionally();
        this.fpsCalculator.setActive(false);
        logger.debug((Object)("MoveOperation-performance: " + this.fpsCalculator.getFps()));
    }

    public void repaintConditionally() {
        if (!this.paintingImmediately && this.operation != null) {
            this.paintingImmediately = true;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            this.paintingImmediately = false;
        } else {
            this.repaint(20L);
        }
    }

    protected boolean isMouseOperationInProgress() {
        return this.operation != null;
    }

    protected boolean isMouseOperationPossible() {
        return this.currentIndicator != null && this.currentIndicator != SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE;
    }

    protected void installLineals(LinealModel horizontalLinealModel, HorizontalPositionsModel horizontalPositionsModel) {
        ElementRenderer elementRenderer = this.getElementRenderer();
        LinealModel verticalLinealModel = elementRenderer != null ? elementRenderer.getVerticalLinealModel() : null;
        if (this.verticalLinealModel != null) {
            this.verticalLinealModel.removeLinealModelListener(this.repaintHandler);
        }
        if (this.horizontalLinealModel != null) {
            this.horizontalLinealModel.removeLinealModelListener(this.repaintHandler);
        }
        this.horizontalPositionsModel = horizontalPositionsModel;
        this.verticalLinealModel = verticalLinealModel;
        this.horizontalLinealModel = horizontalLinealModel;
        if (this.verticalLinealModel != null) {
            this.verticalLinealModel.addLinealModelListener(this.repaintHandler);
        }
        if (this.horizontalLinealModel != null) {
            this.horizontalLinealModel.addLinealModelListener(this.repaintHandler);
        }
        if (elementRenderer != null) {
            elementRenderer.removeChangeListener(this.repaintHandler);
            elementRenderer.addChangeListener(this.repaintHandler);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        ElementRenderer rendererRoot = this.getElementRenderer();
        if (rendererRoot == null) {
            return new Dimension(0, 0);
        }
        float zoom = this.getRenderContext().getZoomModel().getZoomAsPercentage();
        try {
            Rectangle2D bounds = rendererRoot.getBounds();
            int leftBorder = this.isShowLeftBorder() ? (int)this.getLeftBorder() : 0;
            int topBorder = this.isShowTopBorder() ? (int)this.getTopBorder() : 0;
            int width = (int)((double)zoom * ((double)leftBorder + bounds.getWidth()));
            int height = (int)((double)zoom * ((double)topBorder + bounds.getHeight()));
            return new Dimension(width, height);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return new Dimension(0, (int)((double)zoom * rendererRoot.getVisualHeight()));
        }
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    protected boolean stopCellEditing() {
        if (!this.isEditing()) {
            return true;
        }
        ReportElementInlineEditor elementInlineEditor = this.getCellEditor();
        if (elementInlineEditor == null) {
            return true;
        }
        return elementInlineEditor.stopCellEditing();
    }

    protected void updateCursorForIndicator() {
        if (this.currentIndicator == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        switch (this.currentIndicator) {
            case NOT_IN_RANGE: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case MOVE: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case BOTTOM_CENTER: {
                this.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case BOTTOM_LEFT: {
                this.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case BOTTOM_RIGHT: {
                this.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case MIDDLE_LEFT: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case MIDDLE_RIGHT: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case TOP_LEFT: {
                this.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case TOP_CENTER: {
                this.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case TOP_RIGHT: {
                this.setCursor(Cursor.getPredefinedCursor(7));
            }
        }
    }

    protected class SelectionRectangleOverlayRenderer
    implements OverlayRenderer {
        @Override
        public void validate(ReportDocumentContext context, double zoomFactor, Point2D sectionOffset) {
        }

        @Override
        public void draw(Graphics2D graphics, Rectangle2D bounds, ImageObserver obs) {
            AbstractRenderComponent.this.paintSelectionRectangle(graphics);
        }
    }

    private class SelectionStateHandler
    implements PropertyChangeListener {
        private SelectionStateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (AbstractRenderComponent.this.getDesignerContext().isSelectionWaiting()) {
                AbstractRenderComponent.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                AbstractRenderComponent.this.updateCursorForIndicator();
            }
        }
    }

    private class DragAbortReportModelListener
    implements ReportModelListener {
        private DragAbortReportModelListener() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (event.isNodeAddedEvent() || event.isNodeDeleteEvent()) {
                AbstractRenderComponent.this.finishDragOperation();
            }
        }
    }

    protected class CellEditorRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!AbstractRenderComponent.this.isEditing() || !AbstractRenderComponent.this.isTerminateEditOnFocusLost()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == AbstractRenderComponent.this) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(AbstractRenderComponent.this) || AbstractRenderComponent.this.getCellEditor().stopCellEditing()) break;
                AbstractRenderComponent.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    private class MouseOperationHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private SelectionOverlayInformation currentRenderer;
        private Point2D lastPoint;

        private MouseOperationHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.lastPoint == null) {
                return;
            }
            Point2D normalizedPoint = AbstractRenderComponent.this.normalize(e.getPoint());
            AbstractRenderComponent.this.updateElements(normalizedPoint, e.isAltDown(), e.isControlDown());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point1 = e.getPoint();
            this.updateCursor(point1);
        }

        private void updateCursor(Point rawPoint) {
            boolean selectionMode = AbstractRenderComponent.this.getDesignerContext().isSelectionWaiting();
            if (selectionMode) {
                AbstractRenderComponent.this.setCursor(Cursor.getPredefinedCursor(1));
                AbstractRenderComponent.this.currentIndicator = SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE;
                return;
            }
            AbstractRenderComponent.this.currentIndicator = SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE;
            Point2D normalizedPoint = AbstractRenderComponent.this.normalize(rawPoint);
            if (this.currentRenderer != null) {
                AbstractRenderComponent.this.currentIndicator = this.currentRenderer.getMouseInRangeIndicator(normalizedPoint);
                if (AbstractRenderComponent.this.currentIndicator == SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE) {
                    this.currentRenderer = null;
                    AbstractRenderComponent.this.currentIndicator = SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE;
                }
                if (AbstractRenderComponent.this.currentIndicator == SelectionOverlayInformation.InRangeIndicator.MOVE) {
                    this.currentRenderer = null;
                    AbstractRenderComponent.this.currentIndicator = SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE;
                }
            }
            for (Element e : AbstractRenderComponent.this.getRenderContext().getSelectionModel().getSelectedElementsOfType(Element.class)) {
                SelectionOverlayInformation renderer;
                SelectionOverlayInformation.InRangeIndicator indicator;
                Object o = e.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "selection-overlay-information");
                if (!(o instanceof SelectionOverlayInformation) || !AbstractRenderComponent.this.isLocalElement((ReportElement)e) || (indicator = (renderer = (SelectionOverlayInformation)o).getMouseInRangeIndicator(normalizedPoint)) == SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE) continue;
                if (AbstractRenderComponent.this.currentIndicator != SelectionOverlayInformation.InRangeIndicator.MOVE && AbstractRenderComponent.this.currentIndicator != SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE) break;
                AbstractRenderComponent.this.currentIndicator = indicator;
                this.currentRenderer = renderer;
            }
            AbstractRenderComponent.this.updateCursorForIndicator();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastPoint = AbstractRenderComponent.this.normalize(e.getPoint());
            this.updateCursor(e.getPoint());
            AbstractRenderComponent.this.initializeDragOperation(this.lastPoint, AbstractRenderComponent.this.currentIndicator);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.lastPoint == null) {
                return;
            }
            if (!this.lastPoint.equals(AbstractRenderComponent.this.normalize(e.getPoint()))) {
                AbstractRenderComponent.this.finishDragOperation();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.updateCursor(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.updateCursor(e.getPoint());
        }
    }

    protected class MouseEditorActionHandler
    extends MouseAdapter {
        private MouseEditorActionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!AbstractRenderComponent.this.stopCellEditing()) {
                return;
            }
            if (e.isPopupTrigger()) {
                Point2D point = AbstractRenderComponent.this.normalize(e.getPoint());
                if (point.getX() < 0.0 || point.getY() < 0.0) {
                    return;
                }
                this.showElementPopup(e, point);
                return;
            }
            if (e.getClickCount() >= 2 && e.getButton() == 1) {
                Point2D point = AbstractRenderComponent.this.normalize(e.getPoint());
                if (point.getX() < 0.0 || point.getY() < 0.0) {
                    return;
                }
                Element element = AbstractRenderComponent.this.getElementForLocation(point, true);
                if (element == null) {
                    return;
                }
                String typeName = element.getElementTypeName();
                ReportElementEditor elementEditor = ReportElementEditorRegistry.getInstance().getPlugin(typeName);
                if (elementEditor == null && (elementEditor = ReportElementEditorRegistry.getInstance().getPlugin(null)) == null) {
                    return;
                }
                ReportElementInlineEditor inlineEditor = elementEditor.createInlineEditor();
                if (inlineEditor == null) {
                    return;
                }
                AbstractRenderComponent.this.installEditor(inlineEditor, element);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AbstractRenderComponent.this.stopCellEditing()) {
                return;
            }
            if (e.isPopupTrigger()) {
                Point2D point = AbstractRenderComponent.this.normalize(e.getPoint());
                if (point.getX() < 0.0 || point.getY() < 0.0) {
                    return;
                }
                this.showElementPopup(e, point);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AbstractRenderComponent.this.stopCellEditing()) {
                return;
            }
            if (e.isPopupTrigger()) {
                Point2D point = AbstractRenderComponent.this.normalize(e.getPoint());
                if (point.getX() < 0.0 || point.getY() < 0.0) {
                    return;
                }
                this.showElementPopup(e, point);
            }
        }

        protected void showElementPopup(MouseEvent e, Point2D normalizedPoint) {
            Element element = AbstractRenderComponent.this.getElementForLocation(normalizedPoint, true);
            if (element == null) {
                element = (Element)AbstractRenderComponent.this.findRootBandForPosition(normalizedPoint);
            }
            if (element == null) {
                return;
            }
            JPopupMenu pop = ContextMenuUtility.getMenu(AbstractRenderComponent.this.getDesignerContext(), element);
            if (pop == null) {
                return;
            }
            pop.show(AbstractRenderComponent.this, e.getX(), e.getY());
        }
    }

    protected class KeyboardElementMoveHandler
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            if (!e.isShiftDown() && AbstractRenderComponent.this.getDesignerContext().isSelectionWaiting()) {
                if (AbstractRenderComponent.this.currentIndicator == SelectionOverlayInformation.InRangeIndicator.NOT_IN_RANGE) {
                    AbstractRenderComponent.this.setCursor(Cursor.getPredefinedCursor(0));
                } else if (AbstractRenderComponent.this.currentIndicator == SelectionOverlayInformation.InRangeIndicator.MOVE) {
                    AbstractRenderComponent.this.setCursor(Cursor.getPredefinedCursor(13));
                }
                AbstractRenderComponent.this.getDesignerContext().setSelectionWaiting(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            List<Element> selectedElements = AbstractRenderComponent.this.getRenderContext().getSelectionModel().getSelectedElementsOfType(Element.class);
            if (selectedElements.isEmpty()) {
                return;
            }
            int keyCode = keyEvent.getKeyCode();
            if (keyCode != 38 && keyCode != 40 && keyCode != 37 && keyCode != 39) {
                return;
            }
            if (keyEvent.isShiftDown() || keyEvent.isAltDown() || keyEvent.isControlDown()) {
                return;
            }
            keyEvent.consume();
            for (Element element : selectedElements) {
                if (element instanceof RootLevelBand) continue;
                double elementX = element.getStyle().getDoubleStyleProperty(ElementStyleKeys.POS_X, 0.0);
                double elementY = element.getStyle().getDoubleStyleProperty(ElementStyleKeys.POS_Y, 0.0);
                if (keyCode == 38 && elementY == 0.0) {
                    return;
                }
                if (keyCode != 37 || elementX != 0.0) continue;
                return;
            }
            MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(selectedElements);
            MoveDragOperation mop = new MoveDragOperation(selectedElements, new Point(), EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            if (keyCode == 38) {
                mop.update(new Point(0, -1), 1.0);
            } else if (keyCode == 40) {
                mop.update(new Point(0, 1), 1.0);
            } else if (keyCode == 37) {
                mop.update(new Point(-1, 0), 1.0);
            } else {
                mop.update(new Point(1, 0), 1.0);
            }
            MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
            AbstractRenderComponent.this.getRenderContext().getUndo().addChange(Messages.getString("AbstractRenderComponent.MoveUndoName", new Object[0]), massElementStyleUndoEntry);
            mop.finish();
        }
    }

    protected class SettingsUpdateHandler
    implements SettingsListener {
        protected SettingsUpdateHandler() {
        }

        @Override
        public void settingsChanged() {
            AbstractRenderComponent.this.updateGridSettings();
            AbstractRenderComponent.this.revalidate();
            AbstractRenderComponent.this.repaintConditionally();
        }
    }

    protected static final class RepaintHandler
    implements LinealModelListener,
    ZoomModelListener,
    ChangeListener {
        private AbstractRenderComponent component;

        private RepaintHandler(AbstractRenderComponent component) {
            this.component = component;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.component.revalidate();
            this.component.repaintConditionally();
        }

        @Override
        public void modelChanged(LinealModelEvent event) {
            this.component.revalidate();
            this.component.repaintConditionally();
        }

        @Override
        public void zoomFactorChanged() {
            this.component.revalidate();
            this.component.repaintConditionally();
            this.component.stopCellEditing();
        }
    }

    protected class SelectionModelListener
    implements ReportSelectionListener {
        protected SelectionModelListener() {
        }

        @Override
        public void selectionAdded(ReportSelectionEvent event) {
            Element velement;
            Object element = event.getElement();
            if (!(element instanceof Element)) {
                return;
            }
            Section rootBand = AbstractRenderComponent.this.getElementRenderer().getElement();
            ZoomModel zoomModel = AbstractRenderComponent.this.getRenderContext().getZoomModel();
            for (Element parentSearch = velement = (Element)element; parentSearch != null; parentSearch = parentSearch.getParentSection()) {
                if (parentSearch != rootBand) continue;
                SelectionOverlayInformation renderer = new SelectionOverlayInformation(velement);
                renderer.validate(zoomModel.getZoomAsPercentage());
                velement.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "selection-overlay-information", (Object)renderer, false);
                AbstractRenderComponent.this.repaintConditionally();
                return;
            }
        }

        @Override
        public void selectionRemoved(ReportSelectionEvent event) {
            Object element = event.getElement();
            if (element instanceof Element) {
                Element e = (Element)element;
                e.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "selection-overlay-information", null, false);
            }
            AbstractRenderComponent.this.repaintConditionally();
        }

        @Override
        public void leadSelectionChanged(ReportSelectionEvent event) {
            Element e;
            if (event.getModel().getSelectionCount() != 1) {
                return;
            }
            Object raw = event.getElement();
            if (!(raw instanceof Element)) {
                return;
            }
            for (e = (Element)raw; e != null && !(e instanceof RootLevelBand); e = e.getParent()) {
            }
            if (e == AbstractRenderComponent.this.getRootBand()) {
                AbstractRenderComponent.this.setFocused(true);
                AbstractRenderComponent.this.repaintConditionally();
                SwingUtilities.invokeLater(new AsyncChangeNotifier());
            } else {
                AbstractRenderComponent.this.setFocused(false);
                AbstractRenderComponent.this.repaintConditionally();
                SwingUtilities.invokeLater(new AsyncChangeNotifier());
            }
        }
    }

    protected class MouseSelectionHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Point2D normalizedSelectionRectangleOrigin;
        private Point selectionRectangleOrigin;
        private Point selectionRectangleTarget;
        private boolean clearSelectionOnDrag;
        private HashSet<Element> newlySelectedElements = new HashSet();

        protected MouseSelectionHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AbstractRenderComponent.this.getDesignerContext().setSelectionWaiting(false);
            this.normalizedSelectionRectangleOrigin = null;
            this.selectionRectangleOrigin = null;
            this.selectionRectangleTarget = null;
            this.newlySelectedElements.clear();
            AbstractRenderComponent.this.repaintConditionally();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            CachedLayoutData data;
            Element element;
            if (!AbstractRenderComponent.this.getDesignerContext().isSelectionWaiting()) {
                return;
            }
            if (AbstractRenderComponent.this.isMouseOperationInProgress()) {
                return;
            }
            if (this.normalizedSelectionRectangleOrigin == null) {
                return;
            }
            Point2D normalizedSelectionRectangleTarget = AbstractRenderComponent.this.normalize(e.getPoint());
            normalizedSelectionRectangleTarget.setLocation(Math.max(0.0, normalizedSelectionRectangleTarget.getX()), Math.max(0.0, normalizedSelectionRectangleTarget.getY()));
            ElementRenderer rendererRoot = AbstractRenderComponent.this.getElementRenderer();
            ReportDocumentContext renderContext = AbstractRenderComponent.this.getRenderContext();
            if (this.clearSelectionOnDrag) {
                DocumentContextSelectionModel selectionModel = renderContext.getSelectionModel();
                selectionModel.clearSelection();
                this.clearSelectionOnDrag = false;
            }
            this.selectionRectangleTarget = e.getPoint();
            double y1 = Math.min(this.normalizedSelectionRectangleOrigin.getY(), normalizedSelectionRectangleTarget.getY());
            double x1 = Math.min(this.normalizedSelectionRectangleOrigin.getX(), normalizedSelectionRectangleTarget.getX());
            double y2 = Math.max(this.normalizedSelectionRectangleOrigin.getY(), normalizedSelectionRectangleTarget.getY());
            double x2 = Math.max(this.normalizedSelectionRectangleOrigin.getX(), normalizedSelectionRectangleTarget.getX());
            Element[] allNodes = rendererRoot.getElementsAt(x1, y1, x2 - x1, y2 - y1);
            DocumentContextSelectionModel selectionModel = renderContext.getSelectionModel();
            StrictBounds rect1 = StrictGeomUtility.createBounds((double)x1, (double)y1, (double)(x2 - x1), (double)(y2 - y1));
            StrictBounds rect2 = new StrictBounds();
            for (int i = allNodes.length - 1; i >= 0; --i) {
                element = allNodes[i];
                if (element instanceof RootLevelBand) continue;
                data = ModelUtility.getCachedLayoutData(element);
                rect2.setRect(data.getX(), data.getY(), data.getWidth(), data.getHeight());
                if (!StrictBounds.intersects((StrictBounds)rect1, (StrictBounds)rect2) || !selectionModel.add(element)) continue;
                this.newlySelectedElements.add(element);
            }
            Iterator<Element> visualReportElementIterator = this.newlySelectedElements.iterator();
            while (visualReportElementIterator.hasNext()) {
                element = visualReportElementIterator.next();
                data = ModelUtility.getCachedLayoutData(element);
                rect2.setRect(data.getX(), data.getY(), data.getWidth(), data.getHeight());
                if (StrictBounds.intersects((StrictBounds)rect1, (StrictBounds)rect2)) continue;
                selectionModel.remove(element);
                visualReportElementIterator.remove();
            }
            AbstractRenderComponent.this.repaintConditionally();
        }

        public Point getSelectionRectangleOrigin() {
            return this.selectionRectangleOrigin;
        }

        public Point getSelectionRectangleTarget() {
            return this.selectionRectangleTarget;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (AbstractRenderComponent.this.isMouseOperationPossible()) {
                return;
            }
            if (!AbstractRenderComponent.this.getDesignerContext().isSelectionWaiting()) {
                return;
            }
            this.newlySelectedElements.clear();
            this.normalizedSelectionRectangleOrigin = AbstractRenderComponent.this.normalize(e.getPoint());
            this.normalizedSelectionRectangleOrigin.setLocation(Math.max(0.0, this.normalizedSelectionRectangleOrigin.getX()), Math.max(0.0, this.normalizedSelectionRectangleOrigin.getY()));
            this.selectionRectangleOrigin = e.getPoint();
            if (!e.isShiftDown()) {
                this.clearSelectionOnDrag = true;
            }
            ReportDocumentContext renderContext = AbstractRenderComponent.this.getRenderContext();
            ElementRenderer rendererRoot = AbstractRenderComponent.this.getElementRenderer();
            DocumentContextSelectionModel selectionModel = renderContext.getSelectionModel();
            Element[] allNodes = rendererRoot.getElementsAt(this.normalizedSelectionRectangleOrigin.getX(), this.normalizedSelectionRectangleOrigin.getY());
            for (int i = allNodes.length - 1; i >= 0; --i) {
                Element element = allNodes[i];
                if (element instanceof RootLevelBand || e.isShiftDown() || selectionModel.isSelected(element)) continue;
                selectionModel.clearSelection();
                selectionModel.add(element);
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Section element;
            Point2D point = AbstractRenderComponent.this.normalize(e.getPoint());
            if (point.getX() < 0.0 || point.getY() < 0.0) {
                return;
            }
            DocumentContextSelectionModel selectionModel = AbstractRenderComponent.this.getRenderContext().getSelectionModel();
            ElementRenderer rendererRoot = AbstractRenderComponent.this.getElementRenderer();
            Element[] allNodes = rendererRoot.getElementsAt(point.getX(), point.getY());
            for (int i = allNodes.length - 1; i >= 0; --i) {
                Element element2 = allNodes[i];
                if (element2 instanceof RootLevelBand) continue;
                if (e.isShiftDown()) {
                    this.toggleSelection(selectionModel, element2);
                } else if (!selectionModel.isSelected(element2)) {
                    selectionModel.clearSelection();
                    selectionModel.add(element2);
                }
                return;
            }
            if (!e.isShiftDown()) {
                selectionModel.clearSelection();
            }
            if ((element = rendererRoot.getElement()) instanceof RootLevelBand) {
                if (e.isShiftDown()) {
                    this.toggleSelection(selectionModel, (Element)element);
                } else if (!selectionModel.isSelected(element)) {
                    selectionModel.clearSelection();
                    selectionModel.add(element);
                }
            }
        }

        private void toggleSelection(DocumentContextSelectionModel selectionModel, Element element) {
            if (selectionModel.isSelected(element)) {
                selectionModel.remove(element);
            } else {
                selectionModel.add(element);
            }
        }
    }

    protected class RootBandChangeHandler
    implements SettingsListener,
    ReportModelListener {
        protected RootBandChangeHandler() {
            AbstractRenderComponent.this.updateGridSettings();
        }

        public void nodeChanged(ReportModelEvent event) {
            Object element = event.getElement();
            if (!(element instanceof ReportElement)) {
                return;
            }
            Object parameter = event.getParameter();
            if (parameter instanceof DataFactoryChange || parameter instanceof SubReportParameterChange || parameter instanceof AttributeExpressionChange || parameter instanceof StyleExpressionChange) {
                return;
            }
            AbstractRenderComponent.this.getElementRenderer().invalidateLayout();
            AbstractRenderComponent.this.revalidate();
            AbstractRenderComponent.this.repaintConditionally();
        }

        @Override
        public void settingsChanged() {
            AbstractRenderComponent.this.updateGridSettings();
            AbstractRenderComponent.this.repaintConditionally();
        }
    }

    protected class RequestFocusHandler
    extends MouseAdapter
    implements PropertyChangeListener {
        protected RequestFocusHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AbstractRenderComponent.this.requestFocusInWindow();
            AbstractRenderComponent.this.setFocused(true);
            SwingUtilities.invokeLater(new AsyncChangeNotifier());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean focused;
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            boolean oldFocused = AbstractRenderComponent.this.isFocused();
            boolean bl = focused = owner == AbstractRenderComponent.this;
            if (oldFocused != focused) {
                AbstractRenderComponent.this.setFocused(focused);
                AbstractRenderComponent.this.repaintConditionally();
            }
            SwingUtilities.invokeLater(new AsyncChangeNotifier());
        }
    }

    protected class AsyncChangeNotifier
    implements Runnable {
        protected AsyncChangeNotifier() {
        }

        @Override
        public void run() {
            AbstractElementRenderer elementRenderer = (AbstractElementRenderer)AbstractRenderComponent.this.getElementRenderer();
            elementRenderer.fireChangeEvent();
        }
    }
}

