/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import org.pentaho.reporting.designer.core.editor.report.DesignerCollectSelectedNodesStep;
import org.pentaho.reporting.designer.core.editor.report.SelectLayoutNodes;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.LogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DesignerPageDrawable
extends LogicalPageDrawable {
    private DesignerCollectSelectedNodesStep collectSelectedNodesStep;
    private StrictBounds rootElementBounds;
    private HashSet<InstanceID> rootElementIds;
    private boolean insideRenderedElement;
    private SectionSubType subType;
    private HashSet<InstanceID> renderableParents;

    public DesignerPageDrawable(LogicalPageBox rootBox, OutputProcessorMetaData metaData, ResourceManager resourceManager, Section section) {
        this.init(rootBox, metaData, resourceManager);
        this.setDrawPageBackground(false);
        this.rootElementIds = new HashSet();
        this.rootElementIds.add(section.getObjectID());
        this.subType = this.determineSubType(section);
        if (section instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)section;
            SubReport[] subReports = rlb.getSubReports();
            for (int i = 0; i < subReports.length; ++i) {
                SubReport subReport = subReports[i];
                this.rootElementIds.add(subReport.getObjectID());
            }
        }
        this.renderableParents = new HashSet();
        for (Section parent = section.getParentSection(); parent != null; parent = parent.getParentSection()) {
            this.renderableParents.add(parent.getObjectID());
        }
        SelectLayoutNodes layoutNodes = new SelectLayoutNodes();
        this.rootElementBounds = layoutNodes.select(this.rootElementIds, rootBox, section);
        this.collectSelectedNodesStep = new DesignerCollectSelectedNodesStep();
        this.collectSelectedNodesStep.setRootNodes(this.rootElementIds);
    }

    private SectionSubType determineSubType(Section s) {
        if (s.getReportDefinition() != s.getMasterReport()) {
            return SectionSubType.NORMALFLOW;
        }
        if (s instanceof Watermark) {
            return SectionSubType.WATERMARK;
        }
        if (s instanceof PageFooter) {
            return SectionSubType.FOOTER;
        }
        if (s instanceof PageHeader) {
            return SectionSubType.HEADER;
        }
        return SectionSubType.NORMALFLOW;
    }

    public StrictBounds getRootElementBounds() {
        return this.rootElementBounds;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        this.setOutlineMode(WorkspaceSettings.getInstance().isAlwaysDrawElementFrames());
        super.draw(g2, area);
    }

    protected void processRootBand(StrictBounds pageBounds) {
        if (this.subType == SectionSubType.WATERMARK) {
            WatermarkAreaBox box = this.getRootBox().getWatermarkArea();
            this.setDrawArea(new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight()));
            this.getGraphics().clip(this.createClipRect(this.getDrawArea()));
            this.startProcessing((RenderNode)box);
        } else if (this.subType == SectionSubType.HEADER) {
            BlockRenderBox box = this.getRootBox().getHeaderArea();
            this.setDrawArea(new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight()));
            this.getGraphics().clip(this.createClipRect(this.getDrawArea()));
            this.startProcessing((RenderNode)box);
        } else if (this.subType == SectionSubType.FOOTER) {
            BlockRenderBox box = this.getRootBox().getFooterArea();
            this.setDrawArea(new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight()));
            this.getGraphics().clip(this.createClipRect(this.getDrawArea()));
            this.startProcessing((RenderNode)box);
        } else {
            LogicalPageBox box = this.getRootBox();
            this.setDrawArea(new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight()));
            this.getGraphics().clip(this.createClipRect(this.getDrawArea()));
            this.processBoxChilds((RenderBox)this.getRootBox());
        }
    }

    private boolean isValidDrawTarget(RenderNode node) {
        if (this.renderableParents.contains(node.getInstanceId())) {
            return true;
        }
        while (node != null) {
            if (this.rootElementIds.contains(node.getInstanceId())) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    protected boolean startBox(RenderBox box) {
        StrictBounds bounds;
        if (box.getLayoutNodeType() != 1042 && !StrictBounds.intersects((StrictBounds)this.rootElementBounds, (StrictBounds)(bounds = new StrictBounds(box.getX(), box.getY(), box.getWidth(), box.getHeight())))) {
            return false;
        }
        return super.startBox(box);
    }

    private void finishBox(RenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = false;
        }
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startCanvasBox(box);
    }

    protected void finishCanvasBox(CanvasRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startBlockBox(box);
    }

    protected void finishBlockBox(BlockRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startRowBox(RenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startRowBox(box);
    }

    protected void finishRowBox(RenderBox box) {
        this.finishBox(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startInlineBox(box);
    }

    protected void finishInlineBox(InlineRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startTableCellBox(TableCellRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startTableCellBox(box);
    }

    protected void finishTableCellBox(TableCellRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startTableRowBox(TableRowRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startTableRowBox(box);
    }

    protected void finishTableRowBox(TableRowRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startTableSectionBox(box);
    }

    protected void finishTableSectionBox(TableSectionRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startTableBox(TableRenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startTableBox(box);
    }

    protected void finishTableBox(TableRenderBox box) {
        this.finishBox((RenderBox)box);
    }

    protected boolean startOtherBox(RenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startOtherBox(box);
    }

    protected void finishOtherBox(RenderBox box) {
        this.finishBox(box);
    }

    protected boolean startAutoBox(RenderBox box) {
        if (this.rootElementIds.contains(box.getInstanceId())) {
            this.insideRenderedElement = true;
        }
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return false;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return true;
        }
        return super.startAutoBox(box);
    }

    protected void finishAutoBox(RenderBox box) {
        this.finishBox(box);
    }

    protected void processOtherNode(RenderNode node) {
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui(node)) {
            return;
        }
        if (!this.isValidDrawTarget(node)) {
            return;
        }
        super.processOtherNode(node);
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        if (this.insideRenderedElement && ModelUtility.isHideInLayoutGui((RenderNode)box)) {
            return;
        }
        if (!this.isValidDrawTarget((RenderNode)box)) {
            return;
        }
        super.processRenderableContent(box);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        if (box.getFirstChild() == null) {
            if (box.getPoolSize() > 0) {
                Graphics2D graphics1 = this.getGraphics();
                graphics1.setFont(new Font("Serif", 0, 10));
                graphics1.drawString("Your box is too small ...", (int)StrictGeomUtility.toExternalValue((long)box.getX()), (int)StrictGeomUtility.toExternalValue((long)box.getY()) + 10);
            }
        } else {
            super.processParagraphChilds(box);
        }
    }

    public RenderNode[] getNodesAt(double x, double y, String namespace, String name) {
        return this.collectSelectedNodesStep.getNodesAt(this.getRootBox(), StrictGeomUtility.createBounds((double)x, (double)y, (double)1.0, (double)1.0), namespace, name);
    }

    public RenderNode[] getNodesAt(double x, double y, double width, double height, String namespace, String name) {
        return this.collectSelectedNodesStep.getNodesAt(this.getRootBox(), StrictGeomUtility.createBounds((double)x, (double)y, (double)width, (double)height), namespace, name);
    }

    protected boolean isIgnoreBorderWhenDrawingOutline() {
        return true;
    }

    protected void drawOutlineBox(Graphics2D g2, RenderBox box) {
        if (box.getNodeType() == 322) {
            return;
        }
        g2.setPaint(Color.lightGray);
        double x = StrictGeomUtility.toExternalValue((long)box.getX());
        double y = StrictGeomUtility.toExternalValue((long)box.getY());
        double w = StrictGeomUtility.toExternalValue((long)box.getWidth());
        double h = StrictGeomUtility.toExternalValue((long)box.getHeight());
        Rectangle2D.Double boxArea = this.getBoxArea();
        boxArea.setFrame(x, y, w, h);
        g2.draw(boxArea);
    }

    private static enum SectionSubType {
        NORMALFLOW,
        WATERMARK,
        HEADER,
        FOOTER;

    }
}

