/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ReportElementEditorRegistry {
    private static final String PREFIX = "org.pentaho.reporting.designer.core.report-element-editor.";
    private static final String DEFAULTEDITOR = "org.pentaho.reporting.designer.core.report-element-editor";
    private static ReportElementEditorRegistry instance;
    private HashMap<String, ReportElementEditor> factories = new HashMap();

    public static synchronized ReportElementEditorRegistry getInstance() {
        if (instance == null) {
            instance = new ReportElementEditorRegistry();
            instance.register();
        }
        return instance;
    }

    private void register() {
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String elementType = key.substring(PREFIX.length());
            String className = configuration.getConfigProperty(key);
            ReportElementEditor plugin = (ReportElementEditor)ObjectUtilities.loadAndInstantiate((String)className, ReportElementEditorRegistry.class, ReportElementEditor.class);
            if (plugin == null) continue;
            this.addPlugin(elementType, plugin);
        }
        String className = configuration.getConfigProperty(DEFAULTEDITOR);
        ReportElementEditor plugin = (ReportElementEditor)ObjectUtilities.loadAndInstantiate((String)className, ReportElementEditorRegistry.class, ReportElementEditor.class);
        if (plugin != null) {
            this.addPlugin(null, plugin);
        }
    }

    public void addPlugin(String elementType, ReportElementEditor plugin) {
        if (plugin == null) {
            throw new NullPointerException();
        }
        this.factories.put(elementType, plugin);
    }

    public String[] getPluginKeys() {
        return this.factories.keySet().toArray(new String[this.factories.size()]);
    }

    public ReportElementEditor getPlugin(String elementType) {
        return this.factories.get(elementType);
    }
}

