/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.report.ReportRenderEvent;
import org.pentaho.reporting.designer.core.editor.report.ReportRenderListener;
import org.pentaho.reporting.designer.core.editor.report.layouting.CrosstabRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.RootBandRenderer;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;

public class RootBandRenderingModel {
    private ArrayList<ElementRenderer> rootBandComponents;
    private ReportDocumentContext renderContext;
    private AbstractReportDefinition report;
    private EventListenerList eventListenerList;
    private RendererChangeHandler rendererChangeHandler;

    public RootBandRenderingModel(ReportRenderContext renderContext) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        this.rendererChangeHandler = new RendererChangeHandler();
        this.eventListenerList = new EventListenerList();
        this.rootBandComponents = new ArrayList();
        this.renderContext = renderContext;
        this.report = renderContext.getReportDefinition();
        this.report.addReportModelListener((ReportModelListener)new ModelUpdateListener());
        this.refresh();
    }

    protected boolean isShown(ReportElement element) {
        if (element == null) {
            throw new NullPointerException();
        }
        int length = this.rootBandComponents.size();
        for (int i = 0; i < length; ++i) {
            ElementRenderer renderer = this.rootBandComponents.get(i);
            if (renderer.getRepresentationId() != element.getObjectID()) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventListenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.eventListenerList.remove(ChangeListener.class, changeListener);
    }

    public void addReportRenderListener(ReportRenderListener changeListener) {
        this.eventListenerList.add(ReportRenderListener.class, changeListener);
    }

    public void removeReportRenderListener(ReportRenderListener changeListener) {
        this.eventListenerList.remove(ReportRenderListener.class, changeListener);
    }

    protected void fireReportRenderEvent() {
        ReportRenderEvent ce = new ReportRenderEvent(this);
        ReportRenderListener[] changeListeners = (ReportRenderListener[])this.eventListenerList.getListeners(ReportRenderListener.class);
        for (int i = 0; i < changeListeners.length; ++i) {
            ReportRenderListener listener = changeListeners[i];
            listener.layoutChanged(ce);
        }
    }

    protected void fireChangeEvent() {
        ChangeEvent ce = new ChangeEvent(this);
        ChangeListener[] changeListeners = (ChangeListener[])this.eventListenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(ce);
        }
    }

    public ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    public ElementRenderer[] getAllRenderers() {
        return this.rootBandComponents.toArray(new ElementRenderer[this.rootBandComponents.size()]);
    }

    protected void refresh() {
        RelationalGroup relationalGroup;
        Group group;
        int i;
        if (this.report == null) {
            this.clearRenderers();
            this.fireChangeEvent();
            return;
        }
        ArrayList<ElementRenderer> rootBandComponents = new ArrayList<ElementRenderer>(20);
        if (this.renderContext.isBandedContext() && !ModelUtility.isHideInLayoutGui((ReportElement)this.report.getPageHeader())) {
            rootBandComponents.add(new RootBandRenderer((Band)this.report.getPageHeader(), this.renderContext));
        }
        if (!ModelUtility.isHideInLayoutGui((ReportElement)this.report.getReportHeader())) {
            rootBandComponents.add(new RootBandRenderer((Band)this.report.getReportHeader(), this.renderContext));
        }
        Group[] groups = this.collectGroups();
        for (i = 0; i < groups.length; ++i) {
            GroupBody bodyElement;
            group = groups[i];
            if (group instanceof RelationalGroup && !ModelUtility.isHideInLayoutGui((ReportElement)(relationalGroup = (RelationalGroup)group).getHeader())) {
                rootBandComponents.add(new RootBandRenderer((Band)relationalGroup.getHeader(), this.renderContext));
            }
            if ((bodyElement = group.getBody()) instanceof GroupDataBody) {
                GroupDataBody body = (GroupDataBody)bodyElement;
                if (!ModelUtility.isHideInLayoutGui((ReportElement)body.getDetailsHeader())) {
                    rootBandComponents.add(new RootBandRenderer((Band)body.getDetailsHeader(), this.renderContext));
                }
                if (!ModelUtility.isHideInLayoutGui((ReportElement)body.getNoDataBand())) {
                    rootBandComponents.add(new RootBandRenderer((Band)body.getNoDataBand(), this.renderContext));
                }
                if (!ModelUtility.isHideInLayoutGui((ReportElement)body.getItemBand())) {
                    rootBandComponents.add(new RootBandRenderer((Band)body.getItemBand(), this.renderContext));
                }
                if (ModelUtility.isHideInLayoutGui((ReportElement)body.getDetailsFooter())) break;
                rootBandComponents.add(new RootBandRenderer((Band)body.getDetailsFooter(), this.renderContext));
                break;
            }
            if (!(group instanceof CrosstabGroup)) continue;
            rootBandComponents.add(new CrosstabRenderer((CrosstabGroup)group, this.renderContext));
            break;
        }
        for (i = groups.length - 1; i >= 0; --i) {
            group = groups[i];
            if (!(group instanceof RelationalGroup) || ModelUtility.isHideInLayoutGui((ReportElement)(relationalGroup = (RelationalGroup)group).getFooter())) continue;
            rootBandComponents.add(new RootBandRenderer((Band)relationalGroup.getFooter(), this.renderContext));
        }
        if (!ModelUtility.isHideInLayoutGui((ReportElement)this.report.getReportFooter())) {
            rootBandComponents.add(new RootBandRenderer((Band)this.report.getReportFooter(), this.renderContext));
        }
        if (this.renderContext.isBandedContext()) {
            if (!ModelUtility.isHideInLayoutGui((ReportElement)this.report.getPageFooter())) {
                rootBandComponents.add(new RootBandRenderer((Band)this.report.getPageFooter(), this.renderContext));
            }
            if (!ModelUtility.isHideInLayoutGui((ReportElement)this.report.getWatermark())) {
                rootBandComponents.add(new RootBandRenderer((Band)this.report.getWatermark(), this.renderContext));
            }
        }
        if (this.isChange(rootBandComponents)) {
            this.clearRenderers();
            this.rootBandComponents.addAll(rootBandComponents);
            for (i = 0; i < rootBandComponents.size(); ++i) {
                ElementRenderer renderer = rootBandComponents.get(i);
                renderer.addChangeListener(this.rendererChangeHandler);
            }
            this.fireChangeEvent();
        }
    }

    private boolean isChange(ArrayList<ElementRenderer> rootBandComponents) {
        if (rootBandComponents.size() != this.rootBandComponents.size()) {
            return true;
        }
        for (int i = 0; i < rootBandComponents.size(); ++i) {
            ElementRenderer newRenderer = rootBandComponents.get(i);
            ElementRenderer oldRenderer = this.rootBandComponents.get(i);
            if (newRenderer.getRepresentationId() != oldRenderer.getRepresentationId()) {
                return true;
            }
            if (oldRenderer.isHideInLayout() == newRenderer.isHideInLayout()) continue;
            return true;
        }
        return false;
    }

    private Group[] collectGroups() {
        Group group = this.report.getRootGroup();
        ArrayList<Group> list = new ArrayList<Group>();
        while (group != null) {
            SubGroupBody body;
            list.add(group);
            GroupBody bodyElement = group.getBody();
            if (bodyElement instanceof SubGroupBody) {
                body = (SubGroupBody)bodyElement;
                group = body.getGroup();
                continue;
            }
            if (bodyElement instanceof CrosstabOtherGroupBody) {
                body = (CrosstabOtherGroupBody)bodyElement;
                group = body.getGroup();
                continue;
            }
            group = null;
        }
        return list.toArray(new Group[list.size()]);
    }

    public void dispose() {
        this.clearRenderers();
    }

    private void clearRenderers() {
        ElementRenderer[] allRenderers = this.rootBandComponents.toArray(new ElementRenderer[this.rootBandComponents.size()]);
        for (int i = 0; i < allRenderers.length; ++i) {
            ElementRenderer renderer = allRenderers[i];
            renderer.removeChangeListener(this.rendererChangeHandler);
        }
        this.rootBandComponents.clear();
    }

    public PageDefinition getPageDefinition() {
        return ((MasterReport)this.renderContext.getContextRoot()).getPageDefinition();
    }

    private class RendererChangeHandler
    implements ChangeListener {
        private RendererChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RootBandRenderingModel.this.fireReportRenderEvent();
        }
    }

    private class ModelUpdateListener
    implements ReportModelListener {
        private ModelUpdateListener() {
        }

        public void nodeChanged(ReportModelEvent event) {
            boolean stateShow;
            RootLevelBand band;
            boolean modelHide;
            Object element;
            Object o;
            if ((event.isNodeDeleteEvent() || event.isNodeAddedEvent()) && ((o = event.getParameter()) instanceof Group || o instanceof GroupBody || o instanceof RootLevelBand)) {
                RootBandRenderingModel.this.refresh();
                return;
            }
            if (event.getType() == 3 && event.getElement() instanceof RootLevelBand) {
                RootBandRenderingModel.this.refresh();
            }
            if (event.getType() == 0 && (element = event.getElement()) instanceof RootLevelBand && (modelHide = ModelUtility.isHideInLayoutGui((ReportElement)(band = (RootLevelBand)element))) == (stateShow = RootBandRenderingModel.this.isShown((ReportElement)band))) {
                RootBandRenderingModel.this.refresh();
            }
        }
    }
}

