/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.elements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementInlineEditor;
import org.pentaho.reporting.designer.core.util.table.StringValueCellEditor;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class DefaultReportElementInlineEditor
extends StringValueCellEditor
implements ReportElementInlineEditor {
    private AttributeMetaData selectedMetaData;
    private ReportElement reportElement;

    @Override
    public Component getElementCellEditorComponent(ReportElementEditorContext rootBandRenderComponent, ReportElement value) {
        if (value == null) {
            return null;
        }
        this.setReportDesignerContext(rootBandRenderComponent.getDesignerContext());
        this.selectedMetaData = this.selectMetaData(value);
        if (this.selectedMetaData == null) {
            return null;
        }
        if (this.selectedMetaData.isComputed()) {
            this.selectedMetaData = null;
            return null;
        }
        if (!String.class.equals((Object)this.selectedMetaData.getTargetType())) {
            return null;
        }
        if ("Resource".equals(this.selectedMetaData.getValueRole())) {
            return null;
        }
        this.reportElement = value;
        Component editor = this.create(this.selectedMetaData.getValueRole(), this.selectedMetaData.getExtraCalculationFields(), this.getAttributeValue());
        if (editor != null) {
            String fontName = (String)this.reportElement.getStyle().getStyleProperty(TextStyleKeys.FONT);
            int fontSize = this.reportElement.getStyle().getIntStyleProperty(TextStyleKeys.FONTSIZE, 8);
            boolean fontBold = this.reportElement.getStyle().getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean fontItalics = this.reportElement.getStyle().getBooleanStyleProperty(TextStyleKeys.ITALIC);
            Color color = (Color)this.reportElement.getStyle().getStyleProperty(ElementStyleKeys.PAINT);
            Color bgColor = (Color)this.reportElement.getStyle().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)Color.WHITE);
            int fs = 0;
            if (fontBold) {
                fs |= 1;
            }
            if (fontItalics) {
                fs |= 2;
            }
            this.configureEditorStyle(new Font(fontName, fs, fontSize), color, bgColor);
        }
        return editor;
    }

    private AttributeMetaData selectMetaData(ReportElement element) {
        ElementMetaData elementMetaData = element.getMetaData();
        AttributeMetaData fieldData = elementMetaData.getAttributeDescription("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (fieldData != null) {
            return fieldData;
        }
        return elementMetaData.getAttributeDescription("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
    }

    public Object getAttributeValue() {
        if (this.selectedMetaData == null) {
            return null;
        }
        if (this.reportElement == null) {
            return null;
        }
        return this.reportElement.getAttribute(this.selectedMetaData.getNameSpace(), this.selectedMetaData.getName());
    }

    @Override
    public boolean stopCellEditing() {
        if (this.selectedMetaData == null) {
            super.cancelCellEditing();
            return true;
        }
        if (this.reportElement == null) {
            super.cancelCellEditing();
            return true;
        }
        this.reportElement.setAttribute(this.selectedMetaData.getNameSpace(), this.selectedMetaData.getName(), this.getCellEditorValue());
        return super.stopCellEditing();
    }
}

