/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLEditorKit;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.report.MigrateReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;

public class MigrateReportTask
implements Runnable {
    private final ReportDesignerContext designerContext;
    private final ReportDocumentContext reportContext;
    private final long minimumVersionNeeded;

    public MigrateReportTask(ReportDesignerContext designerContext, ReportDocumentContext reportContext, long minimumVersionNeeded) {
        this.designerContext = designerContext;
        this.reportContext = reportContext;
        this.minimumVersionNeeded = minimumVersionNeeded;
    }

    @Override
    public void run() {
        MasterReport masterReportElement = (MasterReport)this.reportContext.getContextRoot();
        Integer compatibilityLevel = masterReportElement.getCompatibilityLevel();
        if (compatibilityLevel == null) {
            return;
        }
        if ((long)compatibilityLevel.intValue() > this.minimumVersionNeeded) {
            return;
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)this.designerContext.getView().getParent());
        MigrateConfirmationDialog dialog = window instanceof JDialog ? new MigrateConfirmationDialog((JDialog)window) : (window instanceof JFrame ? new MigrateConfirmationDialog((JFrame)window) : new MigrateConfirmationDialog());
        UserInput userInput = dialog.performSelection();
        if (userInput == UserInput.Clear) {
            masterReportElement.setCompatibilityLevel(null);
        } else if (userInput == UserInput.Migrate) {
            MigrateReportAction.migrateReport(this.designerContext);
        }
    }

    private static class MigrateConfirmationDialog
    extends CommonDialog {
        private UserInput input;

        private MigrateConfirmationDialog() {
            this.init();
        }

        private MigrateConfirmationDialog(Frame owner) throws HeadlessException {
            super(owner);
            this.init();
        }

        private MigrateConfirmationDialog(Dialog owner) throws HeadlessException {
            super(owner);
            this.init();
        }

        protected void init() {
            this.setTitle(Messages.getString("MigrateReportTask.Title", new Object[0]));
            this.setModal(true);
            super.init();
        }

        protected void performInitialResize() {
            this.setSize(500, 200);
            LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
        }

        protected Action getConfirmAction() {
            return null;
        }

        protected String getDialogId() {
            return "MigrateReportTask.MigrateConfirmationDialog";
        }

        protected Component createContentPane() {
            JEditorPane textArea = new JEditorPane();
            textArea.setEditable(false);
            textArea.setBackground(new Color(0, 0, 0, 0));
            textArea.setOpaque(false);
            textArea.setEditorKit(new HTMLEditorKit());
            textArea.setText(Messages.getString("MigrateReportTask.Message", ClassicEngineBoot.printVersion((int)ClassicEngineBoot.computeCurrentVersionId())));
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add(textArea);
            return panel;
        }

        protected JPanel createButtonsPane() {
            JButton migrateButton = new JButton(new SelectionAction(Messages.getString("MigrateReportTask.Migrate", new Object[0]), UserInput.Migrate));
            JButton clearButton = new JButton(new SelectionAction(Messages.getString("MigrateReportTask.Clear", new Object[0]), UserInput.Clear));
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout(2, 5, 5));
            if (!MacOSXIntegration.MAC_OS_X) {
                buttonsPanel.add(migrateButton);
                buttonsPanel.add(clearButton);
            }
            if (this.hasCancelButton()) {
                buttonsPanel.add(new JButton(this.getCancelAction()));
            }
            if (MacOSXIntegration.MAC_OS_X) {
                buttonsPanel.add(migrateButton);
                buttonsPanel.add(clearButton);
            }
            return buttonsPanel;
        }

        public UserInput performSelection() {
            this.input = UserInput.Cancel;
            super.performEdit();
            return this.input;
        }

        private class SelectionAction
        extends AbstractAction {
            private UserInput option;

            private SelectionAction(String name, UserInput option) {
                super(name);
                this.option = option;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MigrateConfirmationDialog.this.input = this.option;
                MigrateConfirmationDialog.this.dispose();
            }
        }
    }

    private static enum UserInput {
        Migrate,
        Clear,
        Cancel;

    }
}

