/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerOutputProcessor;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerOutputProcessorMetaData;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerRenderComponentFactory;
import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerReportProcessor;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;

public class ReportLayouter {
    private LogicalPageBox logicalPageBox;
    private ReportDocumentContext reportRenderContext;
    private long lastModCount;
    private DesignerOutputProcessorMetaData metaData;
    private DesignerRenderComponentFactory componentFactory;

    public ReportLayouter(ReportRenderContext reportRenderContext) {
        this.reportRenderContext = reportRenderContext;
        this.lastModCount = 0L;
    }

    public LogicalPageBox layout() throws ReportProcessingException, ContentProcessingException {
        MasterReport report = (MasterReport)this.reportRenderContext.getContextRoot();
        if (this.logicalPageBox != null && this.lastModCount == report.getChangeTracker()) {
            return this.logicalPageBox;
        }
        if (this.componentFactory == null) {
            this.componentFactory = new DesignerRenderComponentFactory((OutputProcessorMetaData)this.getOutputProcessorMetaData());
        }
        DesignerOutputProcessor outputProcessor = new DesignerOutputProcessor(this.getOutputProcessorMetaData());
        DesignerReportProcessor reportProcessor = new DesignerReportProcessor(report, outputProcessor, this.componentFactory);
        reportProcessor.processReport();
        this.logicalPageBox = outputProcessor.getLogicalPage();
        this.lastModCount = report.getChangeTracker();
        return this.logicalPageBox;
    }

    public synchronized DesignerOutputProcessorMetaData getOutputProcessorMetaData() {
        if (this.metaData == null) {
            DesignerOutputProcessorMetaData designerOutputProcessorMetaData = new DesignerOutputProcessorMetaData();
            designerOutputProcessorMetaData.initialize(((MasterReport)this.reportRenderContext.getContextRoot()).getConfiguration());
            this.metaData = designerOutputProcessorMetaData;
        }
        return this.metaData;
    }
}

