/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class SubreportDrawable
implements ReportDrawable {
    private Color background;
    private Color foreground;
    private Font font;
    private Object value;

    public SubreportDrawable(Object value) {
        this.value = value;
        this.setStyleSheet(null);
    }

    public void draw(Graphics2D g2, Rectangle2D bounds) {
        Graphics2D graphics2D = (Graphics2D)g2.create();
        graphics2D.clip(bounds);
        graphics2D.setColor(this.background);
        graphics2D.fill(bounds);
        graphics2D.setFont(this.font);
        graphics2D.setColor(this.foreground);
        if (this.value == null) {
            graphics2D.drawString("Subreport", 0.0f, this.font.getSize2D());
        } else {
            graphics2D.drawString(String.valueOf(this.value), 0.0f, this.font.getSize2D());
        }
        graphics2D.dispose();
    }

    public void setConfiguration(Configuration config) {
    }

    public void setStyleSheet(StyleSheet style) {
        if (style != null) {
            this.background = (Color)style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)new Color(159, 224, 255));
            int fontstyle = 0;
            if (style.getBooleanStyleProperty(TextStyleKeys.BOLD)) {
                fontstyle |= 1;
            }
            if (style.getBooleanStyleProperty(TextStyleKeys.ITALIC)) {
                fontstyle |= 2;
            }
            this.font = new Font((String)style.getStyleProperty(TextStyleKeys.FONT, (Object)"SansSerif"), fontstyle, style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 12));
            this.foreground = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
        } else {
            this.background = new Color(159, 224, 255);
            this.font = new Font("SansSerif", 0, 12);
            this.foreground = Color.BLACK;
        }
    }

    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }
}

