/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.StructureTreeCellRenderer;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;

public abstract class AbstractReportTree
extends JTree {
    protected static final DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null, false);
    private ReportDesignerContext reportDesignerContext;
    private boolean updateFromInternalSource;
    private boolean updateFromExternalSource;
    private ReportSelectionHandler selectionHandler = new ReportSelectionHandler();

    public AbstractReportTree() {
        super(EMPTY_MODEL);
        this.addTreeWillExpandListener(new ReportTreeExpansionListener());
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionHandler());
    }

    protected ReportSelectionHandler getSelectionHandler() {
        return this.selectionHandler;
    }

    protected abstract TreePath getPathForNode(Object var1);

    public abstract void setRenderContext(ReportDocumentContext var1);

    protected abstract ReportDocumentContext getRenderContext();

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    protected TreeSet<Integer> getExpandedNodes() {
        ReportDocumentContext renderContext = this.getRenderContext();
        if (renderContext == null) {
            return new TreeSet<Integer>();
        }
        Object property = renderContext.getProperties().get("::layout-report-tree:expanded-nodes");
        if (property instanceof TreeSet) {
            return (TreeSet)property;
        }
        TreeSet<Integer> retval = new TreeSet<Integer>();
        renderContext.getProperties().put("::layout-report-tree:expanded-nodes", retval);
        return retval;
    }

    protected void addExpandedNode(int row) {
        this.getExpandedNodes().add(row);
    }

    protected void removeExpandedNode(int row) {
        this.getExpandedNodes().remove(row);
    }

    protected void restoreState() {
        SwingUtilities.invokeLater(new RestoreStateTask());
    }

    protected boolean isUpdateFromInternalSource() {
        return this.updateFromInternalSource;
    }

    protected void setUpdateFromInternalSource(boolean updateFromInternalSource) {
        this.updateFromInternalSource = updateFromInternalSource;
    }

    protected boolean isUpdateFromExternalSource() {
        return this.updateFromExternalSource;
    }

    protected void setUpdateFromExternalSource(boolean updateFromExternalSource) {
        this.updateFromExternalSource = updateFromExternalSource;
    }

    protected void invalidateLayoutCache() {
        this.setCellRenderer(new StructureTreeCellRenderer());
    }

    private class ReportSelectionHandler
    implements ReportSelectionListener {
        private ReportSelectionHandler() {
        }

        @Override
        public void selectionAdded(ReportSelectionEvent event) {
            if (AbstractReportTree.this.isUpdateFromInternalSource()) {
                return;
            }
            try {
                AbstractReportTree.this.setUpdateFromExternalSource(true);
                TreePath path = AbstractReportTree.this.getPathForNode(event.getElement());
                if (path != null) {
                    AbstractReportTree.this.addSelectionPath(path);
                }
            }
            finally {
                AbstractReportTree.this.setUpdateFromExternalSource(false);
            }
        }

        @Override
        public void selectionRemoved(ReportSelectionEvent event) {
            if (AbstractReportTree.this.isUpdateFromInternalSource()) {
                return;
            }
            try {
                AbstractReportTree.this.setUpdateFromExternalSource(true);
                TreePath path = AbstractReportTree.this.getPathForNode(event.getElement());
                if (path != null) {
                    AbstractReportTree.this.removeSelectionPath(path);
                }
            }
            finally {
                AbstractReportTree.this.setUpdateFromExternalSource(false);
            }
        }

        @Override
        public void leadSelectionChanged(ReportSelectionEvent event) {
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            AbstractReportTree.this.addExpandedNode(AbstractReportTree.this.getRowForPath(e.getPath()));
            if (AbstractReportTree.this.updateFromExternalSource) {
                return;
            }
            AbstractReportTree.this.updateFromInternalSource = true;
            try {
                ReportDocumentContext renderContext = AbstractReportTree.this.getRenderContext();
                if (renderContext == null) {
                    return;
                }
                TreePath[] treePaths = AbstractReportTree.this.getSelectionPaths();
                if (treePaths == null) {
                    AbstractReportTree.this.selectionModel.clearSelection();
                    renderContext.getSelectionModel().clearSelection();
                    return;
                }
                DocumentContextSelectionModel selectionModel = renderContext.getSelectionModel();
                Object[] data = new Object[treePaths.length];
                for (int i = 0; i < treePaths.length; ++i) {
                    TreePath path = treePaths[i];
                    data[i] = path.getLastPathComponent();
                }
                selectionModel.setSelectedElements(data);
            }
            finally {
                AbstractReportTree.this.updateFromInternalSource = false;
            }
        }
    }

    private class ReportTreeExpansionListener
    implements TreeWillExpandListener {
        private ReportTreeExpansionListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            AbstractReportTree.this.addExpandedNode(AbstractReportTree.this.getRowForPath(event.getPath()));
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            AbstractReportTree.this.removeExpandedNode(AbstractReportTree.this.getRowForPath(event.getPath()));
        }
    }

    protected class RestoreStateTask
    implements Runnable {
        protected RestoreStateTask() {
        }

        @Override
        public void run() {
            if (AbstractReportTree.this.getRenderContext() == null) {
                return;
            }
            for (Integer index : AbstractReportTree.this.getExpandedNodes()) {
                AbstractReportTree.this.expandRow(index);
            }
        }
    }

    public static enum RenderType {
        REPORT,
        DATA;

    }
}

