/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportDataTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportParametersNode;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class MasterReportDataTreeModel
extends AbstractReportDataTreeModel {
    private MasterReport masterReportElement;
    private ReportParametersNode reportParametersNode;
    private ParameterDefinitionEntry[] cachedParameterDefinitions;

    public MasterReportDataTreeModel(ReportDocumentContext renderContext) {
        super(renderContext);
        if (!(renderContext.getReportDefinition() instanceof MasterReport)) {
            throw new IllegalArgumentException("Instantiating a MasterReportDataTreeModel on a SubReport-Context");
        }
        this.masterReportElement = (MasterReport)renderContext.getReportDefinition();
        this.reportParametersNode = new ReportParametersNode();
        this.refreshParameterCache();
    }

    protected ReportParametersNode getReportParametersNode() {
        return this.reportParametersNode;
    }

    @Override
    public Object getRoot() {
        return this.masterReportElement;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.masterReportElement) {
            switch (index) {
                case 0: {
                    return this.masterReportElement.getDataFactory();
                }
                case 1: {
                    return this.getReportFunctionNode();
                }
                case 2: {
                    return this.getReportEnvironmentDataRow();
                }
                case 3: {
                    return this.reportParametersNode;
                }
            }
            throw new IndexOutOfBoundsException();
        }
        if (parent == this.reportParametersNode) {
            return this.masterReportElement.getParameterDefinition().getParameterDefinition(index);
        }
        return super.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.masterReportElement) {
            return 4;
        }
        if (parent == this.reportParametersNode) {
            return this.masterReportElement.getParameterDefinition().getParameterCount();
        }
        return super.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof ParameterDefinitionEntry) {
            return true;
        }
        return super.isLeaf(node);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.masterReportElement) {
            if (child == this.masterReportElement.getDataFactory()) {
                return 0;
            }
            if (child == this.getReportFunctionNode()) {
                return 1;
            }
            if (child == this.getReportEnvironmentDataRow()) {
                return 2;
            }
            if (child == this.reportParametersNode) {
                return 3;
            }
            return -1;
        }
        if (parent == this.reportParametersNode) {
            ReportParameterDefinition definition = this.masterReportElement.getParameterDefinition();
            for (int i = 0; i < definition.getParameterCount(); ++i) {
                ParameterDefinitionEntry dataFactory = definition.getParameterDefinition(i);
                if (dataFactory != child) continue;
                return i;
            }
            return -1;
        }
        return super.getIndexOfChild(parent, child);
    }

    @Override
    public TreePath getPathForNode(Object node) {
        if (node instanceof ParameterDefinitionEntry) {
            ReportParametersNode params = this.getReportParametersNode();
            if (this.getIndexOfChild(params, node) < 0) {
                return null;
            }
            return new TreePath(new Object[]{this.getRoot(), params, node});
        }
        return super.getPathForNode(node);
    }

    @Override
    public void fireTreeDataChanged() {
        super.fireTreeDataChanged();
        this.refreshParameterCache();
    }

    @Override
    public void fireTreeStructureChanged(Object element) {
        super.fireTreeStructureChanged(element);
        this.refreshParameterCache();
    }

    public void fireParameterAdded(ParameterDefinitionEntry parameter) {
        TreePath pathForNode = new TreePath(new Object[]{this.getRoot(), this.getReportParametersNode()});
        TreeModelListener[] treeModelListeners = this.getListeners();
        int index = this.getIndexOfChild(this.getReportParametersNode(), parameter);
        if (index == -1) {
            return;
        }
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, pathForNode, new int[]{index}, new Object[]{parameter});
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesInserted(treeEvent);
        }
        this.refreshParameterCache();
    }

    public void fireParameterRemoved(ParameterDefinitionEntry parameter) {
        TreePath pathForNode = new TreePath(new Object[]{this.getRoot(), this.getReportParametersNode()});
        TreeModelListener[] treeModelListeners = this.getListeners();
        int index = this.findParameterInCache(parameter);
        if (index == -1) {
            return;
        }
        TreeModelEvent treeEvent = new TreeModelEvent((Object)this, pathForNode, new int[]{index}, new Object[]{parameter});
        for (int i = treeModelListeners.length - 1; i >= 0; --i) {
            TreeModelListener listener = treeModelListeners[i];
            listener.treeNodesRemoved(treeEvent);
        }
        this.refreshParameterCache();
    }

    private int findParameterInCache(ParameterDefinitionEntry parameter) {
        if (this.cachedParameterDefinitions == null) {
            return -1;
        }
        for (int i = 0; i < this.cachedParameterDefinitions.length; ++i) {
            ParameterDefinitionEntry cachedParameterDefinition = this.cachedParameterDefinitions[i];
            if (parameter != cachedParameterDefinition) continue;
            return i;
        }
        return -1;
    }

    private void refreshParameterCache() {
        this.cachedParameterDefinitions = this.masterReportElement.getParameterDefinition().getParameterDefinitions();
    }
}

