/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.util.Arrays;
import org.pentaho.reporting.designer.core.editor.styles.StyleDataBackend;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;

public abstract class AbstractStyleDataBackend
implements StyleDataBackend {
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final StyleMetaData[] EMPTY_METADATA = new StyleMetaData[0];
    private static final GroupingHeader[] EMPTY_GROUPINGS = new GroupingHeader[0];
    private Object[] propertyEditors;
    private Object[] fullValues;
    private ResolverStyleSheet resolverStyleSheet;
    private StyleMetaData[] metaData;
    private GroupingHeader[] groupings;

    public AbstractStyleDataBackend() {
        this.metaData = EMPTY_METADATA;
        this.groupings = EMPTY_GROUPINGS;
        this.propertyEditors = EMPTY_VALUES;
        this.fullValues = EMPTY_VALUES;
        this.resolverStyleSheet = new ResolverStyleSheet();
    }

    protected AbstractStyleDataBackend(StyleMetaData[] metaData, GroupingHeader[] groupings) {
        this.metaData = metaData;
        this.groupings = groupings;
        this.resolverStyleSheet = new ResolverStyleSheet();
        this.propertyEditors = new Object[this.metaData.length];
        this.fullValues = new Object[this.metaData.length];
    }

    @Override
    public int getRowCount() {
        return this.metaData.length;
    }

    @Override
    public StyleMetaData getMetaData(int row) {
        return this.metaData[row];
    }

    @Override
    public GroupingHeader getGroupings(int row) {
        return this.groupings[row];
    }

    protected GroupingHeader[] getGroupings() {
        return this.groupings;
    }

    @Override
    public void clearCache(int rowIndex) {
        this.fullValues[rowIndex] = null;
    }

    @Override
    public void resetCache() {
        Arrays.fill(this.fullValues, null);
        this.resolverStyleSheet.clear();
    }

    @Override
    public Object[] getFullValues() {
        return this.fullValues;
    }

    @Override
    public Object[] getPropertyEditors() {
        return this.propertyEditors;
    }

    @Override
    public ResolverStyleSheet getResolvedStyle() {
        return this.resolverStyleSheet;
    }
}

