/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.styles.SimpleStyleTableModel;
import org.pentaho.reporting.designer.core.editor.styles.styleeditor.StyleDefinitionEditorContext;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellRenderer;
import org.pentaho.reporting.designer.core.util.table.SortHeaderPanel;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeListener;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.libraries.designtime.swing.DefaultTableHeaderRenderer;

public class SimpleStyleEditorPanel
extends SidePanel {
    protected static final Element[] EMPTY_DATA = new Element[0];
    private SimpleStyleTableModel dataModel;
    private ElementMetaDataTable table;
    private ReportModelChangeHandler changeHandler;
    private SortHeaderPanel headerPanel;
    private StyleDefinitionEditorContext editorContext;

    public SimpleStyleEditorPanel(StyleDefinitionEditorContext editorContext) {
        this.setLayout(new BorderLayout());
        this.editorContext = editorContext;
        this.dataModel = new SimpleStyleTableModel();
        this.table = new ElementMetaDataTable();
        this.table.setModel(new GroupedMetaTableModel(this.dataModel));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GroupedNameCellRenderer());
        this.applyHeaderSize(this.table.getColumnModel().getColumn(1));
        this.changeHandler = new ReportModelChangeHandler(editorContext);
        this.headerPanel = new SortHeaderPanel(this.dataModel);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.setEnabled(true);
    }

    private void applyHeaderSize(TableColumn col) {
        col.setHeaderRenderer((TableCellRenderer)new DefaultTableHeaderRenderer());
        col.sizeWidthToFit();
    }

    public ElementStyleSheet getData() {
        return this.dataModel.getData();
    }

    public void setData(ElementStyleSheet elements) {
        ElementStyleSheet data;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if ((data = this.dataModel.getData()) != null) {
            data.removeListener((StyleChangeListener)this.changeHandler);
        }
        this.dataModel.setData(elements);
        if (elements != null) {
            elements.addListener((StyleChangeListener)this.changeHandler);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.headerPanel.setEnabled(enabled);
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        this.table.setReportDesignerContext(newContext);
    }

    private class ReportModelChangeHandler
    implements StyleChangeListener {
        private StyleDefinitionEditorContext editorContext;

        private ReportModelChangeHandler(StyleDefinitionEditorContext editorContext) {
            this.editorContext = editorContext;
        }

        public void styleChanged(ElementStyleSheet source, StyleKey key, Object value) {
            SimpleStyleEditorPanel.this.dataModel.setData(source);
            ElementStyleDefinition editorStyleDefinition = this.editorContext.getStyleDefinition();
            editorStyleDefinition.updateRule(source);
        }

        public void styleRemoved(ElementStyleSheet source, StyleKey key) {
            this.styleChanged(source, key, null);
        }
    }
}

