/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.styles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.styles.AbstractStyleDataBackend;
import org.pentaho.reporting.designer.core.editor.styles.AbstractStyleTableModel;
import org.pentaho.reporting.designer.core.editor.styles.StyleDataBackend;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.PlainMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SimpleStyleTableModel
extends AbstractStyleTableModel<SimpleStyleDataBackend> {
    private static final Log logger = LogFactory.getLog(SimpleStyleTableModel.class);
    private SimpleStyleDataBackend oldDataBackend;
    private Executor pool = Executors.newSingleThreadExecutor();

    public SimpleStyleTableModel() {
        super.setDataBackend(new SimpleStyleDataBackend());
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        super.setTableStyle(tableStyle);
        this.pool.execute(new UpdateDataTask(this.getData(), this.isSynchronous()));
    }

    public void setData(ElementStyleSheet elements) {
        SimpleStyleDataBackend backend = (SimpleStyleDataBackend)this.getDataBackend();
        if (this.isSameStyleSheet(elements, backend.getStyleSheet())) {
            SwingUtilities.invokeLater(new AbstractStyleTableModel.SameElementsUpdateDataTask((AbstractStyleTableModel)this, (StyleDataBackend)backend, this.isSynchronous()));
            return;
        }
        this.pool.execute(new UpdateDataTask(elements, this.isSynchronous()));
    }

    private boolean isSameStyleSheet(ElementStyleSheet elements, ElementStyleSheet styleSheet) {
        if (elements == styleSheet) {
            return true;
        }
        if (elements == null) {
            return false;
        }
        if (styleSheet == null) {
            return false;
        }
        return styleSheet.getId() == elements.getId();
    }

    public ElementStyleSheet getData() {
        return ((SimpleStyleDataBackend)this.getDataBackend()).getStyleSheet();
    }

    @Override
    protected synchronized void setDataBackend(SimpleStyleDataBackend dataBackend) {
        this.oldDataBackend = (SimpleStyleDataBackend)this.getDataBackend();
        super.setDataBackend(dataBackend);
    }

    protected SimpleStyleDataBackend updateData(ElementStyleSheet styleSheet) {
        StyleMetaData[] metaData = this.selectCommonAttributes();
        TableStyle tableStyle = this.getTableStyle();
        if (tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainMetaDataComparator());
            return new SimpleStyleDataBackend(metaData, new GroupingHeader[metaData.length], styleSheet);
        }
        if (tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainMetaDataComparator()));
            return new SimpleStyleDataBackend(metaData, new GroupingHeader[metaData.length], styleSheet);
        }
        Arrays.sort(metaData, new GroupedMetaDataComparator());
        Locale locale = Locale.getDefault();
        int groupCount = 0;
        int metaDataCount = 0;
        if (metaData.length > 0) {
            String oldValue = null;
            for (int i = 0; i < metaData.length; ++i) {
                StyleMetaData data = metaData[i];
                if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
                ++metaDataCount;
                if (groupCount == 0) {
                    groupCount = 1;
                    oldValue = data.getGrouping(locale);
                    continue;
                }
                String grouping = data.getGrouping(locale);
                if (ObjectUtilities.equal((Object)oldValue, (Object)grouping)) continue;
                ++groupCount;
                oldValue = grouping;
            }
        }
        StyleMetaData[] groupedMetaData = new StyleMetaData[metaDataCount + groupCount];
        int targetIdx = 0;
        GroupingHeader[] groupings = new GroupingHeader[groupedMetaData.length];
        GroupingHeader group = null;
        for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
            StyleMetaData data = metaData[sourceIdx];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            if (targetIdx == 0) {
                groupings[targetIdx] = group = new GroupingHeader(data.getGrouping(locale));
                ++targetIdx;
            } else {
                String newgroup = data.getGrouping(locale);
                if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                    groupings[targetIdx] = group = new GroupingHeader(newgroup);
                    ++targetIdx;
                }
            }
            groupings[targetIdx] = group;
            groupedMetaData[targetIdx] = data;
            ++targetIdx;
        }
        if (this.oldDataBackend != null) {
            groupings = this.reconcileState(groupings, this.oldDataBackend.getGroupings());
        }
        return new SimpleStyleDataBackend(groupedMetaData, groupings, styleSheet);
    }

    private StyleMetaData[] selectCommonAttributes() {
        HashSet<StyleKey> seenKeys = new HashSet<StyleKey>();
        ArrayList<StyleMetaData> result = new ArrayList<StyleMetaData>();
        ElementMetaData[] allElementTypes = ElementTypeRegistry.getInstance().getAllElementTypes();
        for (int i = 0; i < allElementTypes.length; ++i) {
            ElementMetaData elementType = allElementTypes[i];
            StyleMetaData[] datas = elementType.getStyleDescriptions();
            for (int j = 0; j < datas.length; ++j) {
                StyleMetaData data = datas[j];
                if (!seenKeys.add(data.getStyleKey())) continue;
                result.add(data);
            }
        }
        return result.toArray(new StyleMetaData[result.size()]);
    }

    @Override
    protected Object computeInheritValue(StyleMetaData metaData, int rowIndex) {
        ElementStyleSheet styleSheet = ((SimpleStyleDataBackend)this.getDataBackend()).getStyleSheet();
        if (styleSheet == null) {
            return null;
        }
        return !styleSheet.isLocalKey(metaData.getStyleKey());
    }

    @Override
    protected boolean defineFullValue(StyleMetaData metaData, Object value) {
        if (value != null && !metaData.getTargetType().isInstance(value)) {
            logger.warn((Object)("Invalid type: " + value + "(" + value.getClass() + ") but expected " + metaData.getTargetType()));
            return false;
        }
        ElementStyleSheet styleSheet = ((SimpleStyleDataBackend)this.getDataBackend()).getStyleSheet();
        if (styleSheet == null) {
            return false;
        }
        long changeTrackerHash = styleSheet.getChangeTrackerHash();
        styleSheet.setStyleProperty(metaData.getStyleKey(), value);
        return changeTrackerHash != styleSheet.getChangeTrackerHash();
    }

    private class UpdateDataTask
    implements Runnable {
        private ElementStyleSheet elements;
        private boolean synchronous;

        private UpdateDataTask(ElementStyleSheet elements, boolean synchronous) {
            this.elements = elements;
            this.synchronous = synchronous;
        }

        @Override
        public void run() {
            try {
                SimpleStyleDataBackend dataBackend = SimpleStyleTableModel.this.updateData(this.elements);
                if (this.synchronous || SwingUtilities.isEventDispatchThread()) {
                    SimpleStyleTableModel.this.setDataBackend(dataBackend);
                    SimpleStyleTableModel.this.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeAndWait(new AbstractStyleTableModel.NotifyChangeTask((AbstractStyleTableModel)SimpleStyleTableModel.this, (StyleDataBackend)dataBackend));
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    public static class SimpleStyleDataBackend
    extends AbstractStyleDataBackend {
        private ElementStyleSheet styleSheet;

        public SimpleStyleDataBackend() {
        }

        public SimpleStyleDataBackend(StyleMetaData[] metaData, GroupingHeader[] groupings, ElementStyleSheet styleSheet) {
            super(metaData, groupings);
            this.styleSheet = styleSheet;
            if (this.styleSheet != null) {
                this.getResolvedStyle().copyFrom(styleSheet);
            }
        }

        @Override
        public void resetCache() {
            super.resetCache();
            if (this.styleSheet != null) {
                this.getResolvedStyle().copyFrom(this.styleSheet);
            }
        }

        public ElementStyleSheet getStyleSheet() {
            return this.styleSheet;
        }
    }
}

