/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultTableModel;
import org.pentaho.reporting.designer.core.util.IconLoader;

public class InspectionResultTable
extends JTable {
    private InspectionResultTableModel inspectionResultTableModel = new InspectionResultTableModel();

    public InspectionResultTable() {
        this.setModel(this.inspectionResultTableModel);
        this.setDefaultRenderer(InspectionResult.class, new InspectionResultTableCellRenderer());
    }

    public InspectionResult getInspectionResult(int row) {
        return this.inspectionResultTableModel.getInspectionResult(row);
    }

    private static class InspectionResultTableCellRenderer
    extends DefaultTableCellRenderer {
        private InspectionResultTableCellRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            if (value instanceof InspectionResult) {
                InspectionResult result = (InspectionResult)value;
                InspectionResult.Severity severity = result.getSeverity();
                if (severity == InspectionResult.Severity.ERROR) {
                    label.setIcon(IconLoader.getInstance().getErrorIcon());
                } else if (severity == InspectionResult.Severity.WARNING) {
                    label.setIcon(IconLoader.getInstance().getWarningIcon());
                } else if (severity == InspectionResult.Severity.HINT) {
                    label.setIcon(IconLoader.getInstance().getInfoIcon());
                }
                label.setText(result.getDescription());
            }
            return label;
        }
    }
}

