/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;

public class InspectionResultTableModel
extends AbstractTableModel
implements InspectionResultListener {
    private ArrayList<InspectionResult> inspectionResults = new ArrayList();

    @Override
    public void notifyInspectionResult(InspectionResult result) {
        this.add(result);
    }

    public boolean add(InspectionResult inspectionResult) {
        for (int i = 0; i < this.inspectionResults.size(); ++i) {
            InspectionResult result = this.inspectionResults.get(i);
            int compareResult = result.getSeverity().compareTo(inspectionResult.getSeverity());
            if (compareResult >= 0) continue;
            this.inspectionResults.add(i, inspectionResult);
            this.fireTableRowsInserted(i, i);
            return true;
        }
        int index = this.inspectionResults.size();
        this.inspectionResults.add(inspectionResult);
        this.fireTableRowsInserted(index, index);
        return true;
    }

    @Override
    public String getColumnName(int column) {
        return Messages.getString("InspectionResult.Description", new Object[0]);
    }

    @Override
    public int getRowCount() {
        return this.inspectionResults.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return InspectionResult.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.inspectionResults.get(rowIndex);
    }

    public InspectionResult getInspectionResult(int row) {
        return this.inspectionResults.get(row);
    }

    public void clear() {
        this.inspectionResults.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void notifyInspectionStarted() {
        this.clear();
    }
}

