/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class InspectionsRegistry {
    static final String PREFIX = "org.pentaho.reporting.designer.inspections.";
    private static InspectionsRegistry instance;
    private ArrayList<Inspection> factories = new ArrayList();

    public static synchronized InspectionsRegistry getInstance() {
        if (instance == null) {
            instance = new InspectionsRegistry();
            instance.register();
        }
        return instance;
    }

    private void register() {
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String className = configuration.getConfigProperty(key);
            Inspection plugin = (Inspection)ObjectUtilities.loadAndInstantiate((String)className, InspectionsRegistry.class, Inspection.class);
            if (plugin == null) continue;
            this.factories.add(plugin);
        }
    }

    public void addInspection(Inspection plugin) {
        if (plugin == null) {
            throw new NullPointerException();
        }
        this.factories.add(plugin);
    }

    public Inspection[] getInspections() {
        return this.factories.toArray(new Inspection[this.factories.size()]);
    }
}

