/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.StyleLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class FontSizeInspection
extends AbstractStructureInspection {
    private OutputProcessorMetaData outputProcessorMetaData;

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        this.outputProcessorMetaData = new GenericOutputProcessorMetaData();
        super.inspect(designerContext, reportRenderContext, resultHandler);
    }

    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        long effectiveLineHeight;
        boolean dynHeight = element.getStyle().getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT);
        if (dynHeight) {
            return;
        }
        if (element instanceof Section) {
            return;
        }
        ElementMetaData metaData = element.getMetaData();
        if (metaData.isContainerElement()) {
            return;
        }
        if (!this.isTextElement(metaData)) {
            return;
        }
        int minHeight = element.getStyle().getIntStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0);
        double lineHeight = element.getStyle().getIntStyleProperty(TextStyleKeys.LINEHEIGHT, 0);
        int declaredFontSize = element.getStyle().getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
        FontMetrics fontMetrics = this.outputProcessorMetaData.getFontMetrics((StyleSheet)element.getStyle());
        double fontHeight = StrictGeomUtility.toExternalValue((long)RenderableText.convert((long)fontMetrics.getMaxHeight()));
        if (fontHeight <= Math.max((double)minHeight, StrictGeomUtility.toExternalValue((long)(effectiveLineHeight = RenderLength.resolveLength((long)StrictGeomUtility.toInternalValue((double)declaredFontSize), (double)lineHeight))))) {
            return;
        }
        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FontSizeInspection.ElementHeightSmallerThanLineSize", element.getName()), new StyleLocationInfo(element, ElementStyleKeys.MIN_HEIGHT, false)));
    }

    private boolean isTextElement(ElementMetaData metaData) {
        Class aClass = metaData.getContentType();
        if (String.class == aClass) {
            return true;
        }
        return "legacy-element".equals(metaData.getName());
    }
}

