/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class InvalidFieldReferenceInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        AttributeMetaData[] datas = element.getMetaData().getAttributeDescriptions();
        for (int i = 0; i < datas.length; ++i) {
            AttributeMetaData data = datas[i];
            Object value = element.getAttribute(data.getNameSpace(), data.getName());
            String[] referencedFields = data.getReferencedFields(element, value);
            for (int j = 0; j < referencedFields.length; ++j) {
                String field = referencedFields[j];
                if (this.isValidField(field, columnNames)) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.AttributeInvalidField", element.getName(), field, data.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, data.getNameSpace(), data.getName(), false)));
            }
        }
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        if (element instanceof SubReport && element != reportRenderContext.getReportDefinition()) {
            SubReport report = (SubReport)element;
            ParameterMapping[] parameterMappings = report.getInputMappings();
            for (int i = 0; i < parameterMappings.length; ++i) {
                ParameterMapping mapping = parameterMappings[i];
                if ("*".equals(mapping.getName()) || this.isValidField(mapping.getName(), columnNames)) continue;
                String message = Messages.getString("InvalidFieldReferenceInspection.SubReportInvalidField", report.getName(), mapping.getName());
                InspectionResult ir = new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, message, new LocationInfo(report));
                resultHandler.notifyInspectionResult(ir);
            }
        }
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] propertyDescriptions = expressionMetaData.getPropertyDescriptions();
            for (int x = 0; x < propertyDescriptions.length; ++x) {
                ExpressionPropertyMetaData metaData = propertyDescriptions[x];
                Object o = utility.getProperty(metaData.getName());
                String[] referencedFields = metaData.getReferencedFields(expression, o);
                for (int y = 0; y < referencedFields.length; ++y) {
                    String field = referencedFields[y];
                    if (this.isValidField(field, columnNames)) continue;
                    AttributeMetaData attrMetaData = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
                    if (attrMetaData == null) {
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.AttributeExpressionInvalidFieldNoMetaData", element.getName(), attributeNamespace, attributeName, field, metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
                        continue;
                    }
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.AttributeExpressionInvalidField", element.getName(), attrMetaData.getDisplayName(Locale.getDefault()), field, metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] propertyDescriptions = expressionMetaData.getPropertyDescriptions();
            for (int x = 0; x < propertyDescriptions.length; ++x) {
                ExpressionPropertyMetaData metaData = propertyDescriptions[x];
                Object o = utility.getProperty(metaData.getName());
                String[] referencedFields = metaData.getReferencedFields(expression, o);
                for (int y = 0; y < referencedFields.length; ++y) {
                    String field = referencedFields[y];
                    if (this.isValidField(field, columnNames)) continue;
                    StyleMetaData styleDescription = element.getMetaData().getStyleDescription(styleKey);
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.StyleExpressionInvalidField", element.getName(), styleDescription.getDisplayName(Locale.getDefault()), field, metaData.getDisplayName(Locale.getDefault())), new StyleExpressionPropertyLocationInfo(element, styleKey, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                Object o = utility.getProperty(metaData.getName());
                String[] referencedFields = metaData.getReferencedFields(expression, o);
                for (int j = 0; j < referencedFields.length; ++j) {
                    String field = referencedFields[j];
                    if (this.isValidField(field, columnNames)) continue;
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.ExpressionInvalidField", expression.getName(), field, metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, e.getMessage(), new LocationInfo(expression)));
        }
    }

    private boolean isValidField(String field, String[] colnames) {
        for (int i = 0; i < colnames.length; ++i) {
            if (!ObjectUtilities.equal((Object)colnames[i], (Object)field)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void inspectDataSource(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, DataFactory dataFactory) {
        StaticDataRow dataRow = new StaticDataRow(columnNames, new Object[columnNames.length]);
        String[] queries = dataFactory.getQueryNames();
        for (int i = 0; i < queries.length; ++i) {
            DataFactoryMetaData metaData;
            String[] referencedFields;
            String query = queries[i];
            if (!DesignTimeUtil.isSelectedDataSource((AbstractReportDefinition)reportRenderContext.getReportDefinition(), (DataFactory)dataFactory, (String)query) || (referencedFields = (metaData = dataFactory.getMetaData()).getReferencedFields(dataFactory, query, (DataRow)dataRow)) == null) continue;
            for (int j = 0; j < referencedFields.length; ++j) {
                String field = referencedFields[j];
                if (this.isValidField(field, columnNames)) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFieldReferenceInspection.DataSourceInvalidField", metaData.getDisplayName(Locale.getDefault()), field, query), new PropertyLocationInfo(dataFactory, query)));
            }
        }
    }
}

