/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class InvalidGroupReferenceInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        AttributeMetaData[] datas = element.getMetaData().getAttributeDescriptions();
        for (int i = 0; i < datas.length; ++i) {
            AttributeMetaData metaData = datas[i];
            if (!"Group".equals(metaData.getValueRole())) continue;
            Object value = element.getAttribute(metaData.getNameSpace(), metaData.getName());
            String[] groups = metaData.getReferencedGroups(element, value);
            for (int j = 0; j < groups.length; ++j) {
                String group = groups[j];
                AbstractReportDefinition reportDefinition = reportRenderContext.getReportDefinition();
                RelationalGroup e = reportDefinition.getGroupByName(group);
                if (e != null) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidGroupReferenceInspection.AttributeInvalidGroup", element.getName(), group, metaData.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, metaData.getNameSpace(), metaData.getName(), false)));
            }
        }
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData) || !"Group".equals(metaData.getPropertyRole())) continue;
                Object o = utility.getProperty(metaData.getName());
                String[] elements = metaData.getReferencedGroups(expression, o);
                for (int j = 0; j < elements.length; ++j) {
                    String element = elements[j];
                    AbstractReportDefinition reportDefinition = reportRenderContext.getReportDefinition();
                    RelationalGroup e = reportDefinition.getGroupByName(element);
                    if (e != null) continue;
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidGroupReferenceInspection.ExpressionInvalidGroup", expression.getName(), element, metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, e.getMessage(), new LocationInfo(expression)));
        }
    }
}

