/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.ParameterLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;

public class InvalidQueryNameReferenceInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        Throwable throwable;
        AttributeLocationInfo queryLocation;
        super.inspect(designerContext, reportRenderContext, resultHandler);
        AbstractReportDefinition definition = reportRenderContext.getReportDefinition();
        String query = definition.getQuery();
        if (query == null) {
            queryLocation = new AttributeLocationInfo((ReportElement)definition, "http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query", false);
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.HINT, Messages.getString("InvalidQueryNameReferenceInspection.QueryUndefined", new Object[0]), queryLocation));
        } else if (!this.isQueryExecutable(definition, query)) {
            queryLocation = new AttributeLocationInfo((ReportElement)definition, "http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query", false);
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.ERROR, Messages.getString("InvalidQueryNameReferenceInspection.QueryNotRecognized", query), queryLocation));
        }
        ContextAwareDataSchemaModel dataSchemaModel = reportRenderContext.getReportDataSchemaModel();
        if (!dataSchemaModel.isValid() && (throwable = dataSchemaModel.getDataFactoryException()) != null) {
            CompoundDataFactory cdf;
            DataFactory element;
            DataFactory dataFactory = ((MasterReport)reportRenderContext.getContextRoot()).getDataFactory();
            LocationInfo queryLocation2 = dataFactory instanceof CompoundDataFactory ? ((element = (cdf = (CompoundDataFactory)dataFactory).getDataFactoryForQuery(query)) == null ? new LocationInfo(dataFactory) : new LocationInfo(element)) : new LocationInfo(dataFactory);
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.ERROR, Messages.getString("InvalidQueryNameReferenceInspection.QueryDidNotExecute", query, throwable.toString()), queryLocation2));
        }
    }

    @Override
    protected void inspectParameter(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportParameterDefinition definition, ParameterDefinitionEntry parameter) {
        if (parameter instanceof DefaultListParameter) {
            DefaultListParameter listParameter = (DefaultListParameter)parameter;
            String query = listParameter.getQueryName();
            if (query == null) {
                ParameterLocationInfo queryLocation = new ParameterLocationInfo(parameter);
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.HINT, Messages.getString("InvalidQueryNameReferenceInspection.QueryUndefined", new Object[0]), queryLocation));
            } else if (!this.isQueryExecutable(reportRenderContext.getReportDefinition(), query)) {
                ParameterLocationInfo queryLocation = new ParameterLocationInfo(parameter);
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.ERROR, Messages.getString("InvalidQueryNameReferenceInspection.QueryNotRecognized", query), queryLocation));
            }
        }
    }

    private boolean isQueryExecutable(AbstractReportDefinition definition, String query) {
        while (definition != null) {
            if (definition.getDataFactory().isQueryExecutable(query, (DataRow)new StaticDataRow())) {
                return true;
            }
            Section parentSection = definition.getParentSection();
            if (parentSection == null) {
                definition = null;
                continue;
            }
            definition = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }
}

