/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class ReportMigrationInspection
extends AbstractStructureInspection {
    private int compatibilityLevel;
    private String compatibilityText;

    @Override
    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        MasterReport masterReportElement = (MasterReport)reportRenderContext.getContextRoot();
        Integer compatibilityLevel = masterReportElement.getCompatibilityLevel();
        if (compatibilityLevel == null || compatibilityLevel == ClassicEngineBoot.VERSION_TRUNK) {
            return;
        }
        if (compatibilityLevel == ClassicEngineBoot.computeCurrentVersionId()) {
            return;
        }
        this.compatibilityLevel = compatibilityLevel;
        this.compatibilityText = ClassicEngineBoot.printVersion((int)compatibilityLevel);
        super.inspect(designerContext, reportRenderContext, resultHandler);
    }

    protected void inspectElement(ReportDesignerContext designerContext, ReportRenderContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        ElementMetaData elementMetaData = element.getMetaData();
        if (elementMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.ElementInvalid", element.getName(), this.compatibilityText), new LocationInfo(element)));
        }
        for (AttributeMetaData attributeMetaData : elementMetaData.getAttributeDescriptions()) {
            if (attributeMetaData.getCompatibilityLevel() <= this.compatibilityLevel) continue;
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.AttributeInvalid", attributeMetaData.getDisplayName(Locale.getDefault()), element.getName(), this.compatibilityText), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
        }
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        AttributeMetaData attributeMetaData = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
        if (attributeMetaData == null) {
            return;
        }
        if (attributeMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.AttributeExpressionDefined", attributeMetaData.getDisplayName(Locale.getDefault()), element.getName(), this.compatibilityText), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
        }
        if (expressionMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.AttributeExpressionInvalid", attributeMetaData.getDisplayName(Locale.getDefault()), element.getName(), this.compatibilityText), new AttributeLocationInfo(element, attributeMetaData.getNameSpace(), attributeMetaData.getName(), false)));
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        StyleMetaData styleMetaData = element.getMetaData().getStyleDescription(styleKey);
        if (styleMetaData == null) {
            return;
        }
        if (styleMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.StyleExpressionInvalid", styleMetaData.getDisplayName(Locale.getDefault()), element.getName(), this.compatibilityText), new StyleLocationInfo(element, styleKey, false)));
        }
        if (expressionMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.StyleExpressionInvalid", styleMetaData.getDisplayName(Locale.getDefault()), element.getName(), this.compatibilityText), new StyleLocationInfo(element, styleKey, false)));
        }
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        if (expressionMetaData.getCompatibilityLevel() > this.compatibilityLevel) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ReportMigrationInspection.ExpressionInvalid", expressionMetaData.getDisplayName(Locale.getDefault()), this.compatibilityText), new LocationInfo(expression)));
        }
    }

    @Override
    public boolean isInlineInspection() {
        return true;
    }
}

