/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model.lineal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.model.lineal.GuideLine;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelEvent;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelListener;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class LinealModel
implements Serializable {
    private ArrayList<GuideLine> guideLines = new ArrayList();
    private transient EventListenerList linealModelListeners = new EventListenerList();
    private long modificationCount;
    private transient GlobalUpdateHandler updateHandler = new GlobalUpdateHandler();

    public LinealModel() {
        WorkspaceSettings.getInstance().addSettingsListener(this.updateHandler);
    }

    public long getModificationCount() {
        return this.modificationCount;
    }

    public GuideLine[] getGuideLines() {
        return this.guideLines.toArray(new GuideLine[this.guideLines.size()]);
    }

    public boolean removeGuideLine(GuideLine guideLine) {
        if (this.guideLines.remove(guideLine)) {
            ++this.modificationCount;
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    public boolean addGuidLine(GuideLine guideLine) {
        if (this.guideLines.add(guideLine)) {
            ++this.modificationCount;
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    public void updateGuideLine(int position, GuideLine guideLine) {
        this.guideLines.set(position, guideLine);
        ++this.modificationCount;
        this.fireModelChanged();
    }

    public int getGuideLineCount() {
        return this.guideLines.size();
    }

    public GuideLine getGuideLine(int index) {
        return this.guideLines.get(index);
    }

    private void fireModelChanged() {
        LinealModelListener[] lml;
        LinealModelEvent event = new LinealModelEvent(this);
        for (LinealModelListener linealModelListener : lml = (LinealModelListener[])this.linealModelListeners.getListeners(LinealModelListener.class)) {
            linealModelListener.modelChanged(event);
        }
    }

    public void addLinealModelListener(LinealModelListener linealModelListener) {
        this.linealModelListeners.add(LinealModelListener.class, linealModelListener);
    }

    public void removeLinealModelListener(LinealModelListener linealModelListener) {
        this.linealModelListeners.remove(LinealModelListener.class, linealModelListener);
    }

    public void parse(String model) {
        try {
            String number = "\\d*(?:\\.\\d*)?";
            Pattern fullPattern = Pattern.compile("\\((\\s*\\w*\\s*,\\s*\\d*(?:\\.\\d*)?\\s*)\\)");
            Matcher m = fullPattern.matcher(model);
            ArrayList<GuideLine> matches = new ArrayList<GuideLine>();
            while (m.find()) {
                String guildeLineDef = m.group(1);
                String[] strings = guildeLineDef.split(",");
                if (strings.length != 2) {
                    return;
                }
                boolean active = "true".equals(strings[0]);
                double pos = Double.parseDouble(strings[1]);
                matches.add(new GuideLine(pos, active));
            }
            this.guideLines.clear();
            this.guideLines.addAll(matches);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    public String externalize() {
        GuideLine[] guidelines = this.getGuideLines();
        if (guidelines.length > 0) {
            StringBuffer b = new StringBuffer(100);
            for (int i = 0; i < guidelines.length; ++i) {
                GuideLine guideline = guidelines[i];
                if (i != 0) {
                    b.append(' ');
                }
                b.append(guideline.externalize());
            }
            return b.toString();
        }
        return null;
    }

    public void setGlobalState(boolean active) {
        GuideLine[] lines = this.getGuideLines();
        for (int i = 0; i < lines.length; ++i) {
            GuideLine line = lines[i];
            this.guideLines.set(i, line.updateActive(active));
            ++this.modificationCount;
        }
        this.fireModelChanged();
    }

    private class GlobalUpdateHandler
    implements SettingsListener {
        private boolean globalState = WorkspaceSettings.getInstance().isSnapToGuideLines();

        private GlobalUpdateHandler() {
        }

        @Override
        public void settingsChanged() {
            boolean newState = WorkspaceSettings.getInstance().isSnapToGuideLines();
            if (this.globalState != newState) {
                this.globalState = newState;
                LinealModel.this.setGlobalState(this.globalState);
            }
        }
    }
}

