/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerInfo;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class SettingsUtil {
    private static Log LOG = LogFactory.getLog(SettingsUtil.class);

    private SettingsUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidConfiguration(File configDirectory) {
        File initMarkerFile = new File(configDirectory, ".init-config-marker");
        if (!initMarkerFile.exists()) {
            return false;
        }
        ReportDesignerInfo reportDesignerInfo = ReportDesignerInfo.getInstance();
        String currentVersion = reportDesignerInfo.getVersion();
        if (StringUtils.isEmpty((String)currentVersion)) return true;
        if (currentVersion.startsWith("TRUNK-SNAPSHOT")) {
            return true;
        }
        Integer[] currentVersionArray = ObjectUtilities.parseVersions((String)currentVersion);
        try {
            byte[] buffer = new byte[500];
            try (FileInputStream fin = new FileInputStream(initMarkerFile);){
                int length = IOUtils.getInstance().readSafely((InputStream)fin, buffer, 0, 500);
                byte[] data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
                String versionString = new String(data, "ISO-8859-1");
                if (StringUtils.isEmpty((String)versionString)) {
                    boolean bl = true;
                    return bl;
                }
                Integer[] versionArray = ObjectUtilities.parseVersions((String)versionString);
                if (ObjectUtilities.compareVersionArrays((Integer[])versionArray, (Integer[])currentVersionArray) < 0) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeVersionTag(File configDirectory) throws IOException {
        File initMarkerFile = new File(configDirectory, ".init-config-marker");
        FileOutputStream fout = new FileOutputStream(initMarkerFile);
        ReportDesignerInfo reportDesignerInfo = ReportDesignerInfo.getInstance();
        String currentVersion = reportDesignerInfo.getVersion();
        if (!StringUtils.isEmpty((String)currentVersion) && !currentVersion.startsWith("TRUNK-SNAPSHOT")) {
            try {
                fout.write(currentVersion.getBytes("ISO-8859-1"));
            }
            finally {
                fout.close();
            }
        } else {
            fout.close();
        }
    }

    public static void createInitialConfiguration() {
        try {
            Configuration theConfiguration = ReportDesignerBoot.getInstance().getGlobalConfig();
            String homeDirectory = theConfiguration.getConfigProperty("user.home");
            File configDirectory = new File(homeDirectory + File.separatorChar + ".pentaho");
            if (!configDirectory.exists() && !configDirectory.mkdir()) {
                return;
            }
            if (SettingsUtil.isValidConfiguration(configDirectory)) {
                return;
            }
            File installDirFile = SettingsUtil.computeInstallationDirectory();
            if (installDirFile != null) {
                File configTemplateDir = new File(installDirFile, "configuration-template");
                if (!configTemplateDir.exists()) {
                    return;
                }
                File configTemplateJndi = new File(configTemplateDir, "simple-jndi");
                File configDirJndi = new File(configDirectory, "simple-jndi");
                if (!configDirJndi.exists()) {
                    FileUtils.copyDirectory((File)configTemplateJndi, (File)configDirJndi);
                }
                File configTemplateConf = new File(configTemplateDir, "report-designer");
                File configDirConf = new File(configDirectory, "report-designer");
                if (configTemplateConf.exists() && configTemplateConf.isDirectory()) {
                    FileUtils.copyDirectory((File)configTemplateConf, (File)configDirConf);
                }
                SettingsUtil.writeVersionTag(configDirectory);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"createInitialConfiguration: IO Error", (Throwable)e);
        }
    }

    public static File computeInstallationDirectory() throws IOException {
        URL location = WorkspaceSettings.class.getProtectionDomain().getCodeSource().getLocation();
        LOG.debug((Object)("InstallationDirectory: Protection-Domain: " + location));
        if (location == null) {
            return null;
        }
        if (!"file".equals(location.getProtocol())) {
            LOG.debug((Object)"InstallationDirectory: Protection-Domain: Protocol failure.");
            return null;
        }
        try {
            File jarPositon = new File(location.getFile());
            if (!jarPositon.isFile()) {
                Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
                String file = URLDecoder.decode(location.getFile(), configuration.getConfigProperty("file.encoding", "ISO-8859-1"));
                jarPositon = new File(file);
            }
            LOG.debug((Object)("InstallationDirectory: JAR file: " + jarPositon));
            if (jarPositon.isFile()) {
                File libDirectory = jarPositon.getCanonicalFile().getParentFile();
                if (libDirectory == null) {
                    LOG.debug((Object)"InstallationDirectory: No lib directory.");
                    return null;
                }
                LOG.debug((Object)("InstallationDirectory: Work directory: " + libDirectory.getParentFile()));
                return libDirectory.getParentFile();
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)"InstallationDirectory: Failed to decode URL: ", (Throwable)ioe);
        }
        LOG.debug((Object)"InstallationDirectory: Work directory: Defaulting to current work directory.");
        return new File(".");
    }
}

