/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.editor.format.SelectCustomColorAction;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.designtime.swing.ColorComboBox;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;

public class ColorSettingsPanel
extends JPanel
implements SettingsPlugin {
    private JComboBox gridColorSelectorBox = new ColorComboBox();
    private JComboBox guideColorSelectorBox = new ColorComboBox();
    private JComboBox alignmentHintColorSelectorBox = new ColorComboBox();
    private JComboBox overlapHintColorSelectorBox = new ColorComboBox();

    public ColorSettingsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(SettingsMessages.getInstance().getString("ColorSettingsPanel.GridColor")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.gridColorSelectorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 3;
        this.add((Component)new EllipsisButton((Action)new SelectCustomColorAction(this.gridColorSelectorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(SettingsMessages.getInstance().getString("ColorSettingsPanel.GuideColor")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.guideColorSelectorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 3;
        this.add((Component)new EllipsisButton((Action)new SelectCustomColorAction(this.guideColorSelectorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(SettingsMessages.getInstance().getString("ColorSettingsPanel.AlignmentHintColor")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.alignmentHintColorSelectorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 3;
        this.add((Component)new EllipsisButton((Action)new SelectCustomColorAction(this.alignmentHintColorSelectorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(SettingsMessages.getInstance().getString("ColorSettingsPanel.OverlapHintColor")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.overlapHintColorSelectorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 3;
        this.add((Component)new EllipsisButton((Action)new SelectCustomColorAction(this.overlapHintColorSelectorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
        this.reset();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getGeneralSettingsIcon32();
    }

    @Override
    public String getTitle() {
        return SettingsMessages.getInstance().getString("ColorSettingsPanel.Title");
    }

    @Override
    public void apply() {
        WorkspaceSettings.getInstance().setGridColor((Color)this.gridColorSelectorBox.getSelectedItem());
        WorkspaceSettings.getInstance().setGuideColor((Color)this.guideColorSelectorBox.getSelectedItem());
        WorkspaceSettings.getInstance().setAlignmentHintColor((Color)this.alignmentHintColorSelectorBox.getSelectedItem());
        WorkspaceSettings.getInstance().setOverlapErrorColor((Color)this.overlapHintColorSelectorBox.getSelectedItem());
    }

    @Override
    public void reset() {
        this.gridColorSelectorBox.setSelectedItem(WorkspaceSettings.getInstance().getGridColor());
        this.guideColorSelectorBox.setSelectedItem(WorkspaceSettings.getInstance().getGuideColor());
        this.alignmentHintColorSelectorBox.setSelectedItem(WorkspaceSettings.getInstance().getAlignmentHintColor());
        this.overlapHintColorSelectorBox.setSelectedItem(WorkspaceSettings.getInstance().getOverlapErrorColor());
    }

    @Override
    public ValidationResult validate(ValidationResult result) {
        return result;
    }
}

