/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.auth.PasswordPolicyManager;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class PasswordExceptionsDialog
extends CommonDialog {
    private DefaultListModel hostModel;
    private JList hostList;
    private RemovePasswordsAction removePasswordsAction;
    private PasswordPolicyManager passwordPolicyManager;

    public PasswordExceptionsDialog() {
        this.init();
    }

    public PasswordExceptionsDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public PasswordExceptionsDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(SettingsMessages.getInstance().getString("PasswordExceptionsDialog.Title"));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.PasswordExceptions";
    }

    protected Component createContentPane() {
        this.removePasswordsAction = new RemovePasswordsAction();
        this.passwordPolicyManager = PasswordPolicyManager.getInstance();
        this.hostModel = new DefaultListModel();
        this.hostList = new JList(this.hostModel);
        this.hostList.addListSelectionListener(this.removePasswordsAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add((Component)new BorderlessButton((Action)this.removePasswordsAction));
        JPanel headerPanel = new JPanel();
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        headerPanel.setLayout(new BorderLayout());
        headerPanel.add((Component)buttonPanel, "East");
        headerPanel.add((Component)new JLabel(SettingsMessages.getInstance().getString("PasswordExceptionsDialog.Message")), "East");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BorderLayout());
        panel.add((Component)headerPanel, "North");
        panel.add((Component)new JScrollPane(this.hostList), "Center");
        return panel;
    }

    public boolean performEdit() {
        this.fillModel();
        return super.performEdit();
    }

    private void fillModel() {
        String[] strings = this.passwordPolicyManager.getManagedHosts();
        this.hostModel.clear();
        for (int i = 0; i < strings.length; ++i) {
            this.hostModel.addElement(strings[i]);
        }
    }

    private class RemovePasswordsAction
    extends AbstractAction
    implements ListSelectionListener {
        private RemovePasswordsAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", SettingsMessages.getInstance().getString("PasswordExceptionsDialog.Remove"));
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selectedRows = PasswordExceptionsDialog.this.hostList.getSelectedIndices();
            this.setEnabled(selectedRows.length > 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedURLs = PasswordExceptionsDialog.this.hostList.getSelectedValues();
            for (int i = 0; i < selectedURLs.length; ++i) {
                String selectedURL = (String)selectedURLs[i];
                if (selectedURL == null) continue;
                PasswordExceptionsDialog.this.passwordPolicyManager.setPasswordStoringAllowed(selectedURL, false);
            }
            PasswordExceptionsDialog.this.fillModel();
        }
    }
}

