/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.ui.ValidationMessage;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class ToolSettingsPanel
extends JPanel {
    private JRadioButton defaultBrowserRadioButton;
    private JRadioButton customExecutableRadioButton;
    private JButton showFileChooserButton;
    private JTextField customExecutableTextField;
    private JTextField customParametersTextField;
    private JLabel sampleCustomExecutableLabel;
    private JLabel customExecutableLabel;
    private JLabel customParametersLabel;

    protected ToolSettingsPanel() {
        this.setLayout(new GridBagLayout());
        this.defaultBrowserRadioButton = new JRadioButton(this.getDefaultApplicationTranslation());
        this.defaultBrowserRadioButton.setEnabled(true);
        this.defaultBrowserRadioButton.addChangeListener(new EnableTextFieldsHandler());
        this.customExecutableRadioButton = new JRadioButton(this.getCustomApplicationTranslation());
        this.customExecutableRadioButton.addChangeListener(new EnableTextFieldsHandler());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultBrowserRadioButton);
        buttonGroup.add(this.customExecutableRadioButton);
        this.showFileChooserButton = new JButton(new SelectExecutableAction());
        this.showFileChooserButton.setMargin(new Insets(0, 0, 0, 0));
        this.customExecutableTextField = new JTextField(null, 0);
        this.customParametersTextField = new JTextField("{0}", 0);
        this.sampleCustomExecutableLabel = new JLabel(SettingsMessages.getInstance().getString("ToolSettingsPanel.sampleCustomExecutableTextArea"));
        this.customExecutableLabel = new JLabel(SettingsMessages.getInstance().getString("ToolSettingsPanel.customExecutableTextField"));
        this.customParametersLabel = new JLabel(SettingsMessages.getInstance().getString("ToolSettingsPanel.customParametersTextField"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.defaultBrowserRadioButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.customExecutableRadioButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.customExecutableLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.customExecutableTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.showFileChooserButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.customParametersLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.customParametersTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.sampleCustomExecutableLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridheight = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.updateState();
    }

    protected String getCustomApplicationTranslation() {
        return SettingsMessages.getInstance().getString("ToolSettingsPanel.customExecutableRadioButton");
    }

    protected String getDefaultApplicationTranslation() {
        return SettingsMessages.getInstance().getString("ToolSettingsPanel.defaultBrowserRadioButton");
    }

    protected void updateState() {
        boolean enable = this.customExecutableRadioButton.isSelected();
        this.customExecutableLabel.setEnabled(enable);
        this.customParametersLabel.setEnabled(enable);
        this.customExecutableTextField.setEnabled(enable);
        this.customParametersTextField.setEnabled(enable);
        this.sampleCustomExecutableLabel.setEnabled(enable);
        this.showFileChooserButton.setEnabled(enable);
    }

    protected void performSelectFile() {
        JFileChooser fileChooser = new JFileChooser();
        int value = fileChooser.showOpenDialog(this);
        if (value == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            try {
                this.customExecutableTextField.setText(selectedFile.getCanonicalPath());
            }
            catch (IOException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
        }
    }

    public boolean isUseDefaultApplication() {
        return this.defaultBrowserRadioButton.isSelected();
    }

    public void setUseDefaultApplication(boolean useDefaultApplication) {
        this.defaultBrowserRadioButton.setSelected(useDefaultApplication);
        this.customExecutableRadioButton.setSelected(!useDefaultApplication);
    }

    public String getCustomExecutable() {
        return this.customExecutableTextField.getText();
    }

    public void setCustomExecutable(String customApplication) {
        this.customExecutableTextField.setText(customApplication);
    }

    public String getCustomExecutableParameters() {
        return this.customParametersTextField.getText();
    }

    public void setCustomExecutableParameters(String customApplication) {
        this.customParametersTextField.setText(customApplication);
    }

    public ValidationResult validate(ValidationResult result) {
        if (this.isUseDefaultApplication()) {
            return result;
        }
        if (!this.getCustomExecutableParameters().contains("{0}")) {
            result.addValidationMessage(new ValidationMessage(ValidationMessage.Severity.ERROR, SettingsMessages.getInstance().getString("ToolSettingsPanel.MissingVariable")));
        }
        return result;
    }

    private class EnableTextFieldsHandler
    implements ChangeListener {
        private EnableTextFieldsHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ToolSettingsPanel.this.updateState();
        }
    }

    private class SelectExecutableAction
    extends AbstractAction {
        private SelectExecutableAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("ToolSettingsPanel.showFileChooserButton"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolSettingsPanel.this.performSelectFile();
        }
    }
}

