/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.splash;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerInfo;
import org.pentaho.reporting.designer.core.splash.BackgroundUI;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;

public class SplashScreen
extends JWindow {
    private static final int XLOC = 293;
    private static final int YLOC = 170;
    private static final int TEXT_WIDTH = 320;
    private static final int LICENSE_HEIGHT = 30;
    private static final int COPYRIGHT_HEIGHT = 180;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Color WHITE = new Color(255, 255, 255);
    private static final EmptyBorder BORDER = new EmptyBorder(0, 0, 0, 0);
    private JLabel statusLabel;
    private static final Font LICENSE_FONT = new Font("SansSerif", 0, 10);

    public SplashScreen() {
        this.addMouseListener(new HideOnClickHandler());
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(LICENSE_FONT);
        this.statusLabel.setHorizontalAlignment(10);
        this.statusLabel.setOpaque(false);
        this.statusLabel.setForeground(WHITE);
        JPanel statusVersionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.insets = new Insets(0, 293, 0, 0);
        c.anchor = 25;
        statusVersionPanel.setOpaque(false);
        statusVersionPanel.setBackground(TRANSPARENT);
        statusVersionPanel.setBorder(BORDER);
        statusVersionPanel.add((Component)this.statusLabel, c);
        JPanel splashPanel = SplashScreen.createSplashPanel();
        splashPanel.add((Component)statusVersionPanel, "South");
        this.setContentPane(splashPanel);
        this.setSize(splashPanel.getPreferredSize());
        SwingUtil.centerFrameOnScreen((Window)this);
    }

    public static JPanel createSplashPanel() {
        ImageIcon picture = IconLoader.getInstance().getAboutDialogPicture();
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setUI(new BackgroundUI(picture));
        imagePanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        JLabel versionLabel = new JLabel();
        String buildString = ReportDesignerInfo.getInstance().getVersion();
        if (buildString == null) {
            versionLabel.setText(Messages.getString("SplashScreen.DevelopmentVersion", new Object[0]));
        } else {
            versionLabel.setText(buildString);
        }
        versionLabel.setText(Messages.getString("SplashScreen.Version", versionLabel.getText()));
        versionLabel.setFont(new Font("SansSerif", 0, 14));
        versionLabel.setOpaque(false);
        versionLabel.setBackground(TRANSPARENT);
        versionLabel.setForeground(WHITE);
        versionLabel.setBorder(BORDER);
        versionLabel.setBounds(293, 210, 320, versionLabel.getPreferredSize().height);
        String year = new SimpleDateFormat("yyyy").format(new Date());
        JTextArea copyrightArea = new JTextArea(Messages.getString("SplashScreen.Copyright", year));
        copyrightArea.setEditable(false);
        copyrightArea.setBounds(293, 250, 320, 30);
        copyrightArea.setOpaque(false);
        copyrightArea.setLineWrap(true);
        copyrightArea.setWrapStyleWord(true);
        copyrightArea.setFont(LICENSE_FONT);
        copyrightArea.setEnabled(false);
        copyrightArea.setBackground(TRANSPARENT);
        copyrightArea.setForeground(WHITE);
        copyrightArea.setBorder(BORDER);
        copyrightArea.setDisabledTextColor(copyrightArea.getForeground());
        JTextArea licenseArea = new JTextArea(Messages.getString("SplashScreen.License", new Object[0]));
        licenseArea.setEditable(false);
        licenseArea.setBounds(293, 280, 320, 180);
        licenseArea.setOpaque(false);
        licenseArea.setLineWrap(true);
        licenseArea.setWrapStyleWord(true);
        licenseArea.setFont(LICENSE_FONT);
        licenseArea.setEnabled(false);
        licenseArea.setBackground(TRANSPARENT);
        licenseArea.setBorder(BORDER);
        licenseArea.setDisabledTextColor(copyrightArea.getForeground());
        JPanel imagePanelOverlay = new JPanel(null);
        imagePanelOverlay.setOpaque(false);
        imagePanelOverlay.add(versionLabel);
        imagePanelOverlay.add(copyrightArea);
        imagePanelOverlay.add(licenseArea);
        imagePanelOverlay.setBackground(TRANSPARENT);
        imagePanel.add(imagePanelOverlay);
        imagePanel.setPreferredSize(new Dimension(picture.getIconWidth(), picture.getIconHeight()));
        return imagePanel;
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
        this.statusLabel.repaint();
    }

    private class HideOnClickHandler
    extends MouseAdapter {
        private HideOnClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SplashScreen.this.setVisible(false);
        }
    }
}

