/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.pentaho.reporting.designer.core.splash.SplashScreen;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class AboutDialog
extends JDialog {
    public AboutDialog() {
        this.setModal(true);
        this.init();
    }

    public AboutDialog(Frame owner) throws HeadlessException {
        super(owner, true);
        this.init();
    }

    public AboutDialog(Dialog owner) throws HeadlessException {
        super(owner, true);
        this.init();
    }

    private void init() {
        this.setTitle(UtilMessages.getInstance().getString("AboutDialog.Title"));
        this.addMouseListener(new DisposeOnClickHandler());
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        JPanel aboutImage = SplashScreen.createSplashPanel();
        imagePanel.add((Component)aboutImage, "Center");
        this.setSize(aboutImage.getPreferredSize());
        this.setContentPane(imagePanel);
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "close");
        this.getRootPane().getActionMap().put("close", new OKAction());
        this.setUndecorated(true);
        this.pack();
        this.setResizable(false);
        LibSwingUtil.centerDialogInParent((Dialog)this);
        this.setVisible(true);
    }

    private class DisposeOnClickHandler
    extends MouseAdapter {
        private DisposeOnClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AboutDialog.this.dispose();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AboutDialog.this.dispose();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AboutDialog.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private OKAction() {
            this.putValue("Name", UtilMessages.getInstance().getString("AboutDialog.OKAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.dispose();
        }
    }
}

