/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;

public class ExpressionListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel rendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof ExpressionMetaData) {
            ExpressionMetaData metaData = (ExpressionMetaData)value;
            boolean deprecated = metaData.isDeprecated();
            boolean expert = metaData.isExpert();
            boolean preferred = metaData.isPreferred();
            String prefix = "";
            if (deprecated) {
                prefix = "*";
            }
            int fontStyle = 0;
            if (expert) {
                fontStyle |= 2;
            }
            if (preferred) {
                fontStyle |= 1;
            }
            rendererComponent.setFont(this.getFont().deriveFont(fontStyle));
            String displayName = metaData.getDisplayName(Locale.getDefault());
            String groupName = metaData.getGrouping(Locale.getDefault());
            rendererComponent.setToolTipText(metaData.getDeprecationMessage(Locale.getDefault()));
            rendererComponent.setText(prefix + displayName + " (" + groupName + ")");
        } else {
            rendererComponent.setText(" ");
        }
        return rendererComponent;
    }
}

