/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import edu.stanford.ejalbert.BrowserLauncher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.settings.ExternalToolSettings;
import org.pentaho.reporting.designer.core.settings.SettingsUtil;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ExternalToolLauncher {
    private static final Log logger = LogFactory.getLog(ExternalToolLauncher.class);
    private static final long timeout = 10000L;

    private ExternalToolLauncher() {
    }

    public static void openURL(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        ExternalToolSettings instance = ExternalToolSettings.getInstance();
        if (instance.isUseDefaultBrowser()) {
            try {
                new BrowserLauncher().openURLinBrowser(url);
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        } else if (!ExternalToolLauncher.execute(instance.getCustomBrowserExecutable(), instance.getCustomBrowserParameters(), url)) {
            throw new IOException(UtilMessages.getInstance().getString("ExternalToolLauncher.errorMessage", (Object)instance.getCustomBrowserExecutable()));
        }
    }

    public static void openPDF(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        ExternalToolSettings toolSettings = ExternalToolSettings.getInstance();
        if (toolSettings.isUseDefaultPDFViewer()) {
            ExternalToolLauncher.openDefaultViewer(file);
        } else if (!ExternalToolLauncher.execute(toolSettings.getCustomPDFViewerExecutable(), toolSettings.getCustomPDFViewerParameters(), file.getCanonicalPath())) {
            throw new IOException(UtilMessages.getInstance().getString("ExternalToolLauncher.errorMessage", (Object)toolSettings.getCustomPDFViewerExecutable()));
        }
    }

    public static void openXLS(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        ExternalToolSettings toolSettings = ExternalToolSettings.getInstance();
        if (toolSettings.isUseDefaultXLSViewer()) {
            try {
                ExternalToolLauncher.openDefaultViewer(file);
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        } else if (!ExternalToolLauncher.execute(toolSettings.getCustomXLSViewerExecutable(), toolSettings.getCustomXLSViewerParameters(), file.getCanonicalPath())) {
            throw new IOException(UtilMessages.getInstance().getString("ExternalToolLauncher.errorMessage", (Object)toolSettings.getCustomXLSViewerExecutable()));
        }
    }

    public static void openRTF(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        ExternalToolSettings toolSettings = ExternalToolSettings.getInstance();
        if (toolSettings.isUseDefaultRTFViewer()) {
            ExternalToolLauncher.openDefaultViewer(file);
        } else if (!ExternalToolLauncher.execute(toolSettings.getCustomRTFViewerExecutable(), toolSettings.getCustomRTFViewerParameters(), file.getCanonicalPath())) {
            throw new IOException(UtilMessages.getInstance().getString("ExternalToolLauncher.errorMessage", (Object)toolSettings.getCustomRTFViewerExecutable()));
        }
    }

    public static void openCSV(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        ExternalToolSettings toolSettings = ExternalToolSettings.getInstance();
        if (toolSettings.isUseDefaultCSVViewer()) {
            ExternalToolLauncher.openDefaultViewer(file);
        } else if (!ExternalToolLauncher.execute(toolSettings.getCustomCSVViewerExecutable(), toolSettings.getCustomCSVViewerParameters(), file.getCanonicalPath())) {
            throw new IOException(UtilMessages.getInstance().getString("ExternalToolLauncher.errorMessage", (Object)toolSettings.getCustomCSVViewerExecutable()));
        }
    }

    public static boolean execute(String executable, String parameters, String file) throws IOException {
        boolean exitValue = false;
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable);
        StringTokenizer tokenizer = new StringTokenizer(parameters);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            s = s.replace("{0}", file);
            command.add(s);
        }
        String osname = ExternalToolLauncher.safeSystemGetProperty("os.name", "<protected by system security>");
        if (StringUtils.startsWithIgnoreCase((String)osname, (String)"Mac OS X")) {
            logger.debug((Object)"Assuming Mac-OS X.");
            if (executable.endsWith(".app") || executable.endsWith(".app/")) {
                command.add(0, "-a");
                command.add(0, "/usr/bin/open");
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command.toArray(new String[command.size()]));
        Process process = null;
        Thread processWrapper = null;
        try {
            process = processBuilder.start();
            processWrapper = new ProcessWrapper(process);
            processWrapper.start();
            processWrapper.join(10000L);
            if (((ProcessWrapper)processWrapper).getfExitCode() != null) {
                exitValue = ((ProcessWrapper)processWrapper).getfExitCode() == 0;
            } else {
                exitValue = false;
                process.destroy();
            }
            logger.debug((Object)("ProcessWrapper exitCode = " + ((ProcessWrapper)processWrapper).getfExitCode()));
        }
        catch (InterruptedException ie) {
            processWrapper.interrupt();
            Thread.currentThread().interrupt();
            process.destroy();
            exitValue = false;
        }
        catch (Exception e) {
            logger.error((Object)("Error in execute shell command " + command + " error: " + e.getMessage()));
            exitValue = false;
        }
        return exitValue;
    }

    protected static String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void openDefaultViewer(File file) throws IOException {
        String osname = ExternalToolLauncher.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = ExternalToolLauncher.safeSystemGetProperty("java.home", ".");
        String fs = ExternalToolLauncher.safeSystemGetProperty("file.separator", File.separator);
        logger.debug((Object)("Running on operating system: " + osname));
        if (StringUtils.startsWithIgnoreCase((String)osname, (String)"windows")) {
            logger.debug((Object)"Detected Windows.");
            if (ExternalToolLauncher.execute("rundll32.exe", "SHELL32.DLL,ShellExec_RunDLL {0}", file.getAbsolutePath())) return;
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        if (StringUtils.startsWithIgnoreCase((String)osname, (String)"Mac OS X")) {
            logger.debug((Object)"Assuming Mac-OS X.");
            if (ExternalToolLauncher.execute("/usr/bin/open", "{0}", file.getCanonicalPath())) return;
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        if (!(StringUtils.startsWithIgnoreCase((String)osname, (String)"Linux") || StringUtils.startsWithIgnoreCase((String)osname, (String)"Solaris") || StringUtils.startsWithIgnoreCase((String)osname, (String)"HP-UX") || StringUtils.startsWithIgnoreCase((String)osname, (String)"AIX") || StringUtils.startsWithIgnoreCase((String)osname, (String)"SunOS"))) {
            logger.debug((Object)"Not a known OS-Type; using browser as generic launcher.");
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        logger.debug((Object)"Assuming unix.");
        File mailcapExe = new File("/usr/bin/run-mailcap");
        if (mailcapExe.exists()) {
            logger.debug((Object)"found /usr/bin/run=mailcap");
            if (ExternalToolLauncher.execute("/usr/bin/run-mailcap", "{0}", file.getCanonicalPath())) return;
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        File installDir = SettingsUtil.computeInstallationDirectory();
        if (installDir == null) {
            logger.debug((Object)"Cannot determine installation directory; using browser as generic launcher.");
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        File privateMailCapExe = new File(installDir, "resources/run-mailcap");
        if (privateMailCapExe.exists()) {
            if (ExternalToolLauncher.execute(privateMailCapExe.getPath(), "{0}", file.getCanonicalPath())) return;
            ExternalToolLauncher.openURL(file.toURI().toURL().toString());
            return;
        }
        logger.debug((Object)"private copy of run-mailcap not found; using browser as generic launcher.");
        ExternalToolLauncher.openURL(file.toURI().toURL().toString());
    }

    static class ProcessWrapper
    extends Thread {
        private final Process fProcess;
        private Integer fExitCode;

        public Integer getfExitCode() {
            return this.fExitCode;
        }

        public ProcessWrapper(Process fProcess) {
            this.fProcess = fProcess;
        }

        @Override
        public void run() {
            try {
                this.fExitCode = this.fProcess.waitFor();
            }
            catch (InterruptedException e) {
                this.fExitCode = 0;
            }
            catch (Exception ex) {
                this.fExitCode = -1;
            }
        }
    }
}

