/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

public class FpsCalculator {
    private int frames;
    private long startTime;
    private long endTime;
    private boolean active;

    public FpsCalculator() {
        this.reset();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.frames = 0;
    }

    public void tick() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.frames;
        this.endTime = System.currentTimeMillis();
    }

    public double getFps() {
        if (this.frames == 0) {
            return 0.0;
        }
        double time = (double)(this.endTime - this.startTime) / 1000.0;
        return (double)this.frames / time;
    }
}

